#include "StrategyManager.h"

using namespace MyBot;


void StrategyManager::updateCombatTask()
{
	BWAPI::Unit targetEnemyUnit = nullptr;
	BWAPI::Position targetEnemyUnitPosition = BWAPI::Positions::None;

	if (BWAPI::Broodwar->self()->getRace() == BWAPI::Races::Zerg) {

		// Ʊ    Ÿũ
		if (true) {

			if (enemyMainBaseLocation != nullptr) {

				// Zerg_Combat_4Drone_Zergling_Rush  , Ȳ  ʰ  
				if (myCurrentCombatStrategy == CombatStrategy::Zerg_Combat_4Drone_Zergling_Rush) {
					insertTask(StrategicTask(TaskGoalType::Attack_Enemy_BaseLocation_With_Early_Zergling_Unit, BWAPI::UnitTypes::None, BWAPI::TechTypes::None, BWAPI::UpgradeTypes::None, nullptr, BWAPI::Positions::None, 0));
				}
				else {
					insertTask(StrategicTask(TaskGoalType::Attack_Enemy_BaseLocation_With_Mutalisk, BWAPI::UnitTypes::None, BWAPI::TechTypes::None, BWAPI::UpgradeTypes::None, nullptr, BWAPI::Positions::None, 0));
					insertTask(StrategicTask(TaskGoalType::Attack_Enemy_BaseLocation_With_Ground_Unit, BWAPI::UnitTypes::None, BWAPI::TechTypes::None, BWAPI::UpgradeTypes::None, nullptr, BWAPI::Positions::None, 0));
				}
			}
		}

		// Ʊ Ȳ   Ÿũ
		if (true) {

			// ź Ŀ : 濡 ÷, , , ũ, ̾𽺺, Żũ    
			//  佺 : Ա . /۸ Բ
			//  ׶ ī : Ա . /۸ Բ
			//  ׶ ̿ :  / ޵ žĿ
			//   : Ա . /۸ Բ
			if (isToBurrowAndAmbushAttackWithLurker) {
				if (InformationManager::Instance().getUnitData(StrategyManager::Instance().enemyPlayer).getNumCreatedUnits(BWAPI::UnitTypes::Protoss_High_Templar) > 6
					|| InformationManager::Instance().getUnitData(StrategyManager::Instance().enemyPlayer).getNumCreatedUnits(BWAPI::UnitTypes::Protoss_Archon) > 6
					|| InformationManager::Instance().getUnitData(StrategyManager::Instance().enemyPlayer).getNumCreatedUnits(BWAPI::UnitTypes::Protoss_Dark_Archon) > 6
					|| InformationManager::Instance().getUnitData(StrategyManager::Instance().enemyPlayer).getNumCreatedUnits(BWAPI::UnitTypes::Protoss_Observer) > 6
					|| InformationManager::Instance().getUnitData(StrategyManager::Instance().enemyPlayer).getNumCreatedUnits(BWAPI::UnitTypes::Protoss_Reaver) > 6
					|| InformationManager::Instance().getUnitData(StrategyManager::Instance().enemyPlayer).getNumCreatedUnits(BWAPI::UnitTypes::Protoss_Carrier) > 6
					|| InformationManager::Instance().getUnitData(StrategyManager::Instance().enemyPlayer).getNumCreatedUnits(BWAPI::UnitTypes::Protoss_Arbiter) > 6
					|| InformationManager::Instance().getUnitData(StrategyManager::Instance().enemyPlayer).getNumCreatedUnits(BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode) > 8
					|| InformationManager::Instance().getUnitData(StrategyManager::Instance().enemyPlayer).getNumCreatedUnits(BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode) > 8
					|| InformationManager::Instance().getUnitData(StrategyManager::Instance().enemyPlayer).getNumCreatedUnits(BWAPI::UnitTypes::Terran_Science_Vessel) > 6
					|| InformationManager::Instance().getUnitData(StrategyManager::Instance().enemyPlayer).getNumCreatedUnits(BWAPI::UnitTypes::Zerg_Mutalisk) > 8
					|| InformationManager::Instance().getUnitData(StrategyManager::Instance().enemyPlayer).getNumCreatedUnits(BWAPI::UnitTypes::Zerg_Guardian) > 8
				) {
					isToBurrowAndAmbushAttackWithLurker = false;
					breakUpSquad(&ambushCombatLurkerSquad);
				}
			}

			if (isToBurrowAndAmbushAttackWithLurker) {
				if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Lurker) >= 4)
				{
					insertTask(StrategicTask(TaskGoalType::Burrow_And_Ambush_Attack_With_Lurker, BWAPI::UnitTypes::None, BWAPI::TechTypes::None, BWAPI::UpgradeTypes::None, nullptr, BWAPI::Positions::None, 0));
				}
			}

			if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Sunken_Colony) < 3) {

				if (InformationManager::Instance().getNumUnits(BWAPI::UnitTypes::Terran_Vulture, InformationManager::Instance().enemyPlayer) >= 3
					|| InformationManager::Instance().getNumUnits(BWAPI::UnitTypes::Zerg_Zergling, InformationManager::Instance().enemyPlayer) >= 6
					|| InformationManager::Instance().getNumUnits(BWAPI::UnitTypes::Protoss_Zealot, InformationManager::Instance().enemyPlayer) >= 4)
				{
					insertTask(StrategicTask(TaskGoalType::Block_And_Hold_On_ChokePoint, BWAPI::UnitTypes::None, BWAPI::TechTypes::None, BWAPI::UpgradeTypes::None, nullptr, BWAPI::Positions::None, 0));
				}
			}

		}

		//  ,    Ʊ    Ÿũ
		if (InformationManager::Instance().enemyRace == BWAPI::Races::Protoss)
		{
			//  ū / Ŀ / ĳ  ̸,   

		}
		else if (InformationManager::Instance().enemyRace == BWAPI::Races::Terran)
		{
		}
		else if (InformationManager::Instance().enemyRace == BWAPI::Races::Zerg)
		{

		}

		// Ư   ߰߿   Ÿũ
		if (true) {

			// ۼ ߽߰
			if (enemyUnitData->getNumUnits(BWAPI::UnitTypes::Protoss_Shuttle) > 0
				|| enemyUnitData->getNumUnits(BWAPI::UnitTypes::Terran_Dropship) > 0)
			{
			}

			// Ʊ    ϲ  ߽߰
			for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer)) {
				BWAPI::Unit enemyUnit = it.first;
				UnitInfo & enemyUnitInfo = it.second;

				if (BWTA::getRegion(enemyUnitInfo.lastPosition) == myMainBaseLocation->getRegion()
					|| BWTA::getRegion(enemyUnitInfo.lastPosition) == myFirstExpansionBaseLocation->getRegion())
				{
					if (enemyUnitInfo.lastHealth > 0 && enemyUnitInfo.isLastPositionValid == true)
					{
						if (enemyUnitInfo.type.isWorker()) {
							insertTask(StrategicTask(TaskGoalType::Attack_Enemy_Worker_In_Main_Region));
							break;
						}
					}
				}
			}
			// Ʊ    ǹ  ߽߰
			for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer)) {
				BWAPI::Unit enemyUnit = it.first;
				UnitInfo & enemyUnitInfo = it.second;

				if (BWTA::getRegion(enemyUnitInfo.lastPosition) == myMainBaseLocation->getRegion()
					|| BWTA::getRegion(enemyUnitInfo.lastPosition) == myFirstExpansionBaseLocation->getRegion())
				{
					if (enemyUnitInfo.lastHealth > 0 && enemyUnitInfo.isLastPositionValid == true)
					{
						if (enemyUnitInfo.type.isBuilding()) {
							if (enemyUnitInfo.type == BWAPI::UnitTypes::Terran_Bunker
								|| enemyUnitInfo.type == BWAPI::UnitTypes::Terran_Refinery
								|| enemyUnitInfo.type == BWAPI::UnitTypes::Protoss_Pylon
								|| enemyUnitInfo.type == BWAPI::UnitTypes::Protoss_Photon_Cannon
								|| enemyUnitInfo.type == BWAPI::UnitTypes::Protoss_Assimilator
								|| enemyUnitInfo.type == BWAPI::UnitTypes::Zerg_Extractor
								|| enemyUnitInfo.type == BWAPI::UnitTypes::Zerg_Creep_Colony
								|| enemyUnitInfo.type == BWAPI::UnitTypes::Zerg_Nydus_Canal
								|| enemyUnitInfo.type == BWAPI::UnitTypes::Zerg_Sunken_Colony)
							{
								insertTask(StrategicTask(TaskGoalType::Attack_Enemy_Dangerous_Building_In_Main_Region));
								break;
							}
						}
					}
				}
			}

			// Ʊ     ߽߰
			for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer)) {
				BWAPI::Unit enemyUnit = it.first;
				UnitInfo & enemyUnitInfo = it.second;

				if (enemyUnitInfo.type.isWorker() == false
					&& enemyUnitInfo.type.canAttack()
					&& enemyUnitInfo.type.isFlyer() == false
					&& enemyUnitInfo.lastHealth > 0
					&& enemyUnitInfo.isLastPositionValid == true) 
				{
					for (BWTA::BaseLocation* baselocation : InformationManager::Instance().getOccupiedBaseLocations(InformationManager::Instance().selfPlayer)) {
						if (baselocation->getPosition().getDistance(enemyUnitInfo.lastPosition) < 16 * TILE_SIZE) {
							insertTask(StrategicTask(TaskGoalType::Attack_Enemy_Ground_Unit_In_Our_Region));
							break;
						}
					}
				}
			}

			// ÷, ũĭ, Ϸ ߽߰

			//  ū / Ŀ / ĳ  ̸,  ū Ǽ   ؼ 

			// Ƽ ߽߰

		}
				
		//  ¸ Ȳ -  ResourceDepot  ı Eliminate Ű 
		if (BWAPI::Broodwar->getFrameCount() > 24 * 60 * 5) {

			int myBuildingCount = 0;
			int myNonBuildingCount = 0;

			int enemyBuildingCount = 0;
			int enemyNonBuildingCount = 0;
			for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer)) {
				BWAPI::Unit enemyUnit = it.first;
				UnitInfo & enemyUnitInfo = it.second;

				if (enemyUnitInfo.type.isBuilding()) {
					enemyBuildingCount++;
				}
				else {
					enemyNonBuildingCount++;
				}
			}
			for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().selfPlayer)) {
				BWAPI::Unit myUnit = it.first;
				UnitInfo & myUnitInfo = it.second;

				if (myUnitInfo.type.isBuilding()) {
					myBuildingCount++;
				}
				else {
					myNonBuildingCount++;
				}
			}

			//    ׿, Ʊ ö̰ 50  Ѿ
			if (selfPlayer->supplyUsed() > 50 * 2) {

				//   Ʊ  20 ̻     
				int myUnitCountAroundEnemyMainBaseLocation = 0;
				for (BWAPI::Unit unit : BWAPI::Broodwar->getUnitsInRadius(enemyMainBaseLocation->getPosition(), 8 * TILE_SIZE)) {
					if (unit->getPlayer() == selfPlayer) {
						myUnitCountAroundEnemyMainBaseLocation++;
					}
				}
				if (myUnitCountAroundEnemyMainBaseLocation > 20) {

					isToBurrowOnEmptyBaseLocation = false;
					isToBurrowAndAmbushAttackWithLurker = false;

					eraseTask(StrategicTask(TaskGoalType::Burrow_On_Empty_BaseLocation));
					eraseTask(StrategicTask(TaskGoalType::Burrow_And_Ambush_Attack_With_Lurker));

					insertTask(StrategicTask(TaskGoalType::Eliminate_Enemy_Player));
				}
			}
		}


	}
}

bool StrategyManager::isGoodTimingToStartGroundAttack()
{
	bool result = false;

	if (BWAPI::Broodwar->self()->getRace() == BWAPI::Races::Zerg) {

		// Ʊ      ,  Ʊ  / ġ / ׷̵ Ȳ  Ǵ
		if (myCurrentCombatStrategy == CombatStrategy::Zerg_Combat_4Drone_Zergling_Rush) {

			result = true;

		}
		else if (myCurrentCombatStrategy == CombatStrategy::Zerg_Combat_Front_Defense_Mutalisk_BackRush) {

			if (myCurrentBuildStrategy == BuildStrategy::Zerg_Build_Zergling_Lurker_Mutalisk) {
				if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Zergling) >= 24
					&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Lurker) >= 4
					&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Mutalisk) >= 12
				){
					result = true;
				}
			}
		}
		else if (myCurrentCombatStrategy == CombatStrategy::Zerg_Combat_Front_Ground_Rush) {
			if (myCurrentBuildStrategy == BuildStrategy::Zerg_Build_Zergling_Only) {
				if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Zergling) >= 12
					){
					result = true;
				}
			}
			else if (myCurrentBuildStrategy == BuildStrategy::Zerg_Build_Zergling_Hydralisk)
			{
				if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Zergling) >= 20
					&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Hydralisk) >= 12
					){
					result = true;
				}
			}
			else if (myCurrentBuildStrategy == BuildStrategy::Zerg_Build_Zergling_Hydralisk_Defiler)
			{
				if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Zergling) >= 20
					&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Hydralisk) >= 24
					&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Defiler) >= 2
					&& BWAPI::Broodwar->self()->hasResearched(BWAPI::TechTypes::Consume) == true
					){
					result = true;
				}
			}
			else if (myCurrentBuildStrategy == BuildStrategy::Zerg_Build_Zergling_Hydralisk_Lurker)
			{
				if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Zergling) >= 20
					&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Hydralisk) >= 24
					&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Lurker) >= 8
				){
					result = true;
				}
			}
			else if (myCurrentBuildStrategy == BuildStrategy::Zerg_Build_Zergling_Hydralisk_Lurker_Defiler)
			{
				if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Zergling) >= 20
					&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Hydralisk) >= 24
					&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Lurker) >= 8
					&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Defiler) >= 2
					&& BWAPI::Broodwar->self()->hasResearched(BWAPI::TechTypes::Consume) == true
				){
					result = true;
				}
			}
			else if (myCurrentBuildStrategy == BuildStrategy::Zerg_Build_Zergling_Lurker_Defiler) {
				if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Zergling) >= 20
					&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Lurker) >= 8
					&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Defiler) >= 2
					&& BWAPI::Broodwar->self()->hasResearched(BWAPI::TechTypes::Consume) == true
					){
					result = true;
				}
			}
			else if (myCurrentBuildStrategy == BuildStrategy::Zerg_Build_Zergling_Lurker_Mutalisk) {
				if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Zergling) >= 20
					&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Lurker) >= 4
					&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Mutalisk) >= 12
				){
					result = true;
				}
			}
			else if (myCurrentBuildStrategy == BuildStrategy::Zerg_Build_Air_Focused) {
				if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Zergling) >= 24
					&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Mutalisk) >= 20
					&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Scourge) >= 8
				){
					result = true;
				}
			}
			else if (myCurrentBuildStrategy == BuildStrategy::Zerg_Build_Zergling_Lurker_Mutalisk) {
				if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Zergling) >= 24
					&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Lurker) >= 4
					&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Mutalisk) >= 8
				){
					result = true;
				}
			}
		}
	}

	return result;
}

bool StrategyManager::isGoodTimingToStartAirAttack()
{
	bool result = false;

	if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Mutalisk) >= 16
		){
		result = true;
	}

	return result;
}
