#pragma once

#include "Common.h"

#include <chrono>

#include "UnitData.h"
#include "BuildOrderQueue.h"
#include "InformationManager.h"
#include "WorkerManager.h"
#include "BuildManager.h"
#include "ConstructionManager.h"
#include "ScoutManager.h"

#include "MapTools.h"
#include "StrategyData.h"
#include "Squad.h"
#include "Strategy_ScoutTaskManager.h"
#include "Strategy_InitialBuildOrderManager.h"
#include "Strategy_BuildTaskManager.h"
#include "Strategy_ExpansionTaskManager.h"
#include "Strategy_CombatTaskManager.h"
#include "UXManager_Additional.h"

#include "ConfidenceMap.h"

namespace MyBot
{

	/// Ȳ ǴϿ, , , ,   ϵ Ѱ ָ ϴ class
	/// InformationManager  ִ κ Ȳ Ǵϰ, 
	/// BuildManager  buildQueue  (ǹ Ǽ /  Ʒ / ũ ġ / ׷̵)  Էմϴ.
	/// , , ,   ϴ ڵ尡  class
	class StrategyManager
	{
		StrategyManager();

		///  ÷ :  ڵ尡  Ű ˱ ÷
		bool isToFindError;

	public:
		/// static singleton ü մϴ
		static StrategyManager &	Instance();

		// 
		std::vector<std::string> words;
		void setWord();
		void sendWord();


		UnitData * enemyUnitData;
		UnitData * myUnitData;
		BWTA::BaseLocation * enemyMainBaseLocation;
		BWTA::BaseLocation * myMainBaseLocation;
		BWTA::BaseLocation * myFirstExpansionBaseLocation;
		BWTA::Chokepoint * myFirstChokepoint;
		BWTA::BaseLocation * enemyFirstExpansionBaseLocation;
		BWTA::Chokepoint * enemyFirstChokepoint;
		BWAPI::Player selfPlayer;
		BWAPI::Player enemyPlayer;
		BWAPI::Race			selfRace;		///< Ʊ Player 		
		BWAPI::Race			enemyRace;		///<  Player   

		/// TODO : StartLocation ġ. BuildStrategy. CombatStrategy. 
		///  ӿ   ϴ ڷᱸ
		class GameRecord {
		public:
			std::string mapName;
			std::string enemyName;
			std::string enemyRace;
			std::string enemyRealRace;
			std::string myName;
			std::string myRace;
			long long gameStartedTime = 0;
			int gameFrameCount = 0;
			int myWinCount = 0;
			int myLoseCount = 0;
		};
		///  ü ӵ  ϴ ڷᱸ
		std::vector<GameRecord> gameRecordList;

		///  ü   εմϴ
		void loadGameRecordList();
		///  ü   + ̹   մϴ
		void saveGameRecordList(bool isWinner);
		/// ̹  ߰  α׸ մϴ
		void saveGameLog();


		BuildStrategy myCurrentBuildStrategy;		///< Ʊ  BuildStrategy		
		BuildStrategy myOldBuildStrategy;			///< Ʊ  BuildStrategy
		BuildStrategy enemyCurrentBuildStrategy;	///<   BuildStrategy		
		BuildStrategy enemyOldBuildStrategy;		///<   BuildStrategy		

		CombatStrategy myCurrentCombatStrategy;		///< Ʊ  CombatStrategy		
		CombatStrategy myOldCombatStrategy;			///< Ʊ  CombatStrategy
		CombatStrategy enemyCurrentCombatStrategy;	///<   CombatStrategy		
		CombatStrategy enemyOldCombatStrategy;		///<   CombatStrategy		

		std::set<StrategicTask> taskList;			///< Ʊ  StrategicTask 

		std::map<BWTA::BaseLocation *, LocationInfo> baseLocationStatusMap; ///< BaseLocation  LocationStatus   		
		std::map<BWTA::Chokepoint *, LocationInfo> chokepointStatusMap; ///< Chokepoint  LocationStatus   		

		std::set<BWTA::Chokepoint *> frontlineChokepointList;	/// <  
		BWAPI::Position frontlinePosition;						/// <   ߽


		///   ġ. // Ÿ ٱ
		std::set<BWAPI::WalkPosition>* safeLevel9Positions;

		///   ġ. β 
		std::set<BWAPI::WalkPosition>* safeLevel5Positions;

		///   ġ. Sea
		std::set<BWAPI::WalkPosition>* safeLevel1Positions;


		/// Ʊ δ
		Squad reservedSquad;				///<  δ

		Squad mainCombatZerglingSquad;		///<   ۸ δ :  / ո 
		Squad mainCombatHydraliskSquad;		///<    δ :  / ո 
		Squad mainCombatLurkerSquad;		///<   Ŀ δ :  / ո 
		Squad mainCombatMutaliskSquad;		///<   Ż/ٿ/ δ :  / ո 
		Squad mainCombatScourgeSquad;		///<   Ŀ δ :  / ո 
		Squad mainCombatOverlordSquad;		///<   ε δ : ε
		Squad mainCombatQueenSquad;			///<    δ : 
		Squad mainCombatDefilerSquad;		///<   Ϸ δ : Ϸ, ̿ ۸,  ε
		Squad mainCombatUltraliskSquad;		///<   Ʈ δ :  / ո 

		Squad reinforceMainCombatMutaliskSquad;		///<   Ż  δ

		Squad subCombatSquad;				///<   δ : Ƽ 
		Squad subCombatOverlordSquad;		///<    δ : ε. 

		Squad subCombatReinforceSquad;		///<   δ

		Squad mainBaseDefenseSquad;			///<    ֵ ϴ δ

		Squad mainBaseClearSquad1;			///<     ްϴ δ : ۸, ϲ 
		Squad mainBaseClearSquad2;			///<    ǹ ްϴ δ : ۸, ϲ 
		Squad mainChokepointBlockingSquad;	///<   /   δ : ۸, ϲ 
		Squad mainBasePatrolSquad;			///<  ֺ Ʈ δ : ۸, Ŀ, ε
		
		Squad firstExpansionDefenseSquad;	///< ո  δ : , Ż
		Squad firstExpansionPatrolSquad;	///< ո ֺ Ʈ δ : ۸, Ŀ, ε

		Squad secondExpansionDefenseSquad;	///< Ƽ  δ : , Ż
		Squad secondExpansionPatrolSquad;	///< Ƽ ֺ Ʈ δ : ۸, Ŀ, ε

		Squad dropAttackSquad;				///< δ : , Ŀ.  ε
		Squad ambushCombatLurkerSquad;		///<  źδ : Ŀ.  ε

		Squad newExpansionSetupSquad;		///< ű Ƽ ô δ : , ε, ۸, 

		Squad scoutDroneSquad;				///<   δ : ʹݿ .  . 
		Squad scoutOverlordSquad1;			///<  ε δ : ʹݿ .  . 
		Squad scoutOverlordSquad2;			///<  ε δ : ʹݿ .  . 
		Squad scoutOverlordSquad3;			///<  ε δ : ʹݿ .  . 
		Squad scoutOverlordSquad4;			///<  ε δ : ʹݿ .  . 
		Squad scoutOverlordSquad5;			///<  ε δ : ʹݿ .  . 
		Squad scoutZerglingSquad;			///<  ۸ δ :  
		Squad scoutScourgeSquad;			///<  Ŀ δ :  
		Squad scoutQueenSquad;				///<   δ :  

		Squad multiObstructZerglingSquad;	///< Ƽ ۸ δ
		Squad multiObstructLurkerSquad;		///< Ƽ Ŀ δ

		//Squad workerSquad;					///< ϲ δ

		std::set<Squad*> allMySquadList;	///< Ʊ ü δ

		std::set<Squad*> squadListToBreakUp;	///< ü  δ


		// 
		int lastFrameOfScoutEnemyBaseLocation;
		int lastFrameOfMultiObstructZerglingSquad;

		// Ȯ
		int numRiskToStartToConstructFirstExpansion;
		int lastFrameOfConstructHatcheryOnFirstExpansion;
		int lastFrameOfConstructCreepColonyOnFirstExpansion;
		int numRiskToStartToConstructSecondExpansion;
		bool isStartedToConstructSecondExpansion;


		// Ǽ
		bool isAlreadySentFirstExpansionHatcheryDrone;
		bool isAlreadySentFirstExpansionCreepColonyDrone;

		void moveWorkerToConstructionPlace();

		///  ۵  ȸ  ʱ    մϴ
		void onStart();
		void setInitialBuildOrder();

		///     ȸ      մϴ
		void onEnd(bool isWinner);

		///     Ӹ     մϴ
		void update();

		/// ٹ̻  
		BWAPI::Position nukeDetectedPosition;

		///  ٹ̻  
		bool isEnemyHasNuclearMissile;

		/// ٹ̻ ߻  
		/// -1 = ٹ̻ ߻  
		/// 0 ʰ = ٹ̻ ߻ 
		int nukeDetectedFrame;
		/// ٹ̻ ߻簡 Ǿ  ߻ϴ ̺Ʈ óմϴ
		void onNukeDetect(BWAPI::Position target);

		/// Ʊ  Ȳ  Ǵ, ׿  StrategicTask  Ʈ 
		void updateStatusAndStrategyAndTaskList();

		void figureOutEnemyStrategy();
		void updateMyStrategy();
		void updateScoutTask();
		void updateBuildTask();
		void updateCombatTask();
		void updateExpansionTask();


		/// Ʊ ֵ δ ġ   ŸƮ 
		void updateSquad();

		///   ÷. ش  ϴ  ǹϰų ս Ŭ   false  .
		bool isToScoutWithOverlord;		///<    ϸ false
		bool isToScoutWithWorker;		///<   佺, ׶̸ false
		bool isToScoutWithZergling;		///< ظϸ true
		bool isToScoutWithScourge;		///< ظϸ true
		bool isToScoutWithQueen;		///< ظϸ true
		bool isEnemyHasDangerousUnitToOverlord; ///<  ε     ϸ true

		///  ϱ  ּ ϲ ο 
		int workerScoutCondition_completedWorkerCount;
		/// ۸   
		int zerglingScouterNumberFromCombatSquad;

		/// 
		void executeScout();
		void cancelScoutDroneSquad();
		void cancelScoutOverlordSquad();

		bool isToBurrowOnEmptyBaseLocation;
		bool isToBurrowAndAmbushAttackWithLurker;

		//  
		bool isToMakeQueen;
		bool isToMakeGuardian;
		bool isToMakeDevourer;
		bool isToMakeUltralisk;

		bool isDefenseEnough();
		bool isGoodTimingToStartGroundAttack();
		bool isGoodTimingToStartAirAttack();

		///  ֿ   ӹ     Ʈ
		///   Ÿũ 
		void executeBuild();

		///   Ÿũ 
		void executeCombat();

		/// Ȯ Ǽ
		int lastFrameOfExpansionStart;
		void executeExpansion();
		bool isGoodTimingToStartAnotherExpansion();

		BWTA::BaseLocation* getMyNextExpansionLocation(TaskGoalType taskGoalType);
		std::vector<BWTA::BaseLocation*> getEnemyNextExpansionLocaion();


		//  : ConfidenceMap
		void updateConfidenceMap();

		ConfidenceMap* confidenceMapForMutalisk;
		ConfidenceMap* confidenceMapForZergling;

		/// Լ - fake mineral      Ǵ
		bool isPossibleToGo(BWTA::BaseLocation* from, BWTA::BaseLocation* to);

		/// Լ - fake mineral ֱ
		BWAPI::TilePosition getNearestFakeMineralPosition(BWAPI::TilePosition fromPosition);
		BWAPI::TilePosition getNearestBaseLocationPositionBlockedByFakeMineral(BWAPI::TilePosition fromPosition);
		bool isFakeMineralCleared;
		BWAPI::Unit fakeMineralClearWorker;
		void clearFakeMineral();

		/// Լ -  ġ ȯ
		BWAPI::Position					getSafePositionForUnit(BWAPI::Unit overlord, BWAPI::Position desiredPosition = BWAPI::Positions::None);
		/// Լ -  ġ ȯ
		BWAPI::Position					getSafePosition(BWAPI::Position desiredPosition);




		/// Լ - Ʊ   
		void setMyBuildStrategy(BuildStrategy newBuildStrategy);
		/// Լ -    
		void setEnemyBuildStrategy(BuildStrategy newBuildStrategy);
		/// Լ - Ʊ   
		void setMyCombatStrategy(CombatStrategy newCombatStrategy);
		/// Լ -    
		void setEnemyCombatStrategy(CombatStrategy newCombatStrategy);

		/// Լ - Ÿũ ϷῩ ľ
		bool isCompletedTask(StrategicTask task);
		/// Լ - Ÿũ ߰
		void insertTask(StrategicTask newTask);
		/// Լ - Ÿũ 
		void eraseTask(StrategicTask targetTask);
		/// Լ - Ϸ Ÿũ Ѵ
		void clearCompletedTask();

		/// Լ -  ⺻  Ʈ
		void updateInformations();

		/// Լ -   Ʈ
		void updateSafePositions();

		/// Լ - ʱ δ 
		void setInitialSquad();
		/// Լ - δ ̸
		std::string getSquadInfo(Squad* squad);
		/// Լ -   δ뿡 Ѵ
		void clearDeadUnitInSquad();
		/// Լ - δ밣  
		void moveUnitBetweenSquad(Squad* from, Squad* to, BWAPI::UnitType unitType, int count = 1, BWAPI::Unit unit = nullptr);
		/// Լ - δ ü (  reservedSquad  )
		void breakUpSquad(Squad* targetSquad);

		/// Լ - Task   Squad  üѴ
		//void breakUpSquadsThatHasNoTask();

		/// Լ - δ  ش Ÿ ּ ȯ
		int getUnitNumberInSquad(Squad* targetSquad, BWAPI::UnitType targetUnitType = BWAPI::UnitTypes::None);

		/// Լ - ü    
		int getMainCombatUnitCount();

		/// Լ - ε ϱ  Ȳΰ
		bool getEnemyHasDangerousUnitToOverlord();
		/// Լ -   Ѿ ϴ Ȳΰ
		bool isVeryDangerousToScoutWithDrone();
		/// Լ - ε  Ѿ ϴ Ȳΰ
		bool isVeryDangerousToEveryOverlord();

		/// Լ - Ʊ   
		std::set<BWTA::Chokepoint*> getMyFrontLineChokepoints();

	};
}
