#include "StrategyData.h"

using namespace MyBot;

std::string StrategicTaskUtil::getTaskGoalTypeString(TaskGoalType taskGoalType)
{
	std::string str = "";

	switch (taskGoalType) {

	case TaskGoalType::Figure_Out_Enemy_Race: str = "Figure_Out_Enemy_Race";
		break;
	case TaskGoalType::Figure_Out_Enemy_BaseLocation: str = "Figure_Out_Enemy_BaseLocation";
		break;
	case TaskGoalType::Scout_Enemy_MainBaseLocation: str = "Scout_Enemy_MainBaseLocation";
		break;
	case TaskGoalType::Scout_Enemy_First_Expansion: str = "Scout_Enemy_First_Expansion";
		break;
	case TaskGoalType::Scout_Enemy_Other_Expansion: str = "Scout_Enemy_Other_Expansion";
		break;
	case TaskGoalType::Scout_Enemy_Chokepoint: str = "Scout_Enemy_Chokepoint";
		break;
	case TaskGoalType::Scout_Empty_BaseLocations: str = "Scout_Empty_BaseLocations";
		break;
	case TaskGoalType::Eliminate_Enemy_Player: str = "Eliminate_Enemy_Player";
		break;

	case TaskGoalType::Build_Unit_Another: str = "Build_Unit_Another";
		break;
	case TaskGoalType::Build_Unit_By_Limit: str = "Build_Unit_By_Limit";
		break;
	case TaskGoalType::Build_Tech: str = "Build_Tech";
		break;
	case TaskGoalType::Build_Upgrade: str = "Build_Upgrade";
		break;
	case TaskGoalType::Build_Expansion_On_Ground: str = "Build_Expansion_On_Ground";
		break;
	case TaskGoalType::Build_Expansion_On_Island: str = "Build_Expansion_On_Island";
		break;

	case TaskGoalType::Attack_Enemy_BaseLocation_With_Ground_Unit: str = "Attack_Enemy_BaseLocation_With_Ground_Unit";
		break;
	case TaskGoalType::Attack_Enemy_BaseLocation_With_Early_Zergling_Unit: str = "Attack_Enemy_BaseLocation_With_Early_Zergling_Unit";
		break;
	case TaskGoalType::AttackEnemyUnits: str = "AttackEnemyUnits";
		break;
	case TaskGoalType::Kill_Unit_Urgently: str = "Kill_Unit_Urgently";
		break;
	case TaskGoalType::Kill_Some_UnitType: str = "Kill_Some_UnitType";
		break;
	case TaskGoalType::Transport_Defiler_Throuth_Overlord: str = "Transport_Defiler_Throuth_Overlord";
		break;
	case TaskGoalType::SlaughterEnemyWorkersWithZergling: str = "SlaughterEnemyWorkersWithZergling";
		break;
	case TaskGoalType::Attack_Enemy_BaseLocation_With_Mutalisk: str = "Attack_Enemy_BaseLocation_With_Mutalisk";
		break;
	case TaskGoalType::SlaughterEnemyWorkersWithLurkerDrop: str = "SlaughterEnemyWorkersWithLurkerDrop";
		break;
	case TaskGoalType::Spray_Plague_On_Enemy_Buildings: str = "Spray_Plague_On_Enemy_Buildings";
		break;
	case TaskGoalType::Spray_Plague_On_Enemy_Units: str = "Spray_Plague_On_Enemy_Units";
		break;

	case TaskGoalType::Defense_Position_With_Zergling: str = "Defense_Position_With_Zergling";
		break;
	case TaskGoalType::Block_And_Hold_On_ChokePoint: str = "Block_And_Hold_On_ChokePoint";
		break;
	case TaskGoalType::Defense_Position_With_SunkenColonies: str = "Defense_Position_With_SunkenColonies";
		break;
	case TaskGoalType::Attack_Enemy_Worker_In_Main_Region: str = "Attack_Enemy_Worker_In_Main_Region";
		break;
	case TaskGoalType::Attack_Enemy_Dangerous_Building_In_Main_Region: str = "Attack_Enemy_Dangerous_Building_In_Main_Region";
		break;
	case TaskGoalType::Attack_Enemy_Ground_Unit_In_Our_Region: str = "Attack_Enemy_Ground_Unit_In_Our_Region";
		break;
	case TaskGoalType::Move_Every_Overlord_To_MainBaseLocation: str = "Move_Every_Overlord_To_MainBaseLocation";
		break;
	case TaskGoalType::Attack_With_Lurker_Drop: str = "Attack_With_Lurker_Drop";
		break;
	case TaskGoalType::Defense_Position_With_Hydralisk: str = "Defense_Position_With_Hydralisk";
		break;		
	case TaskGoalType::Burrow_On_Empty_BaseLocation: str = "Burrow_On_Empty_BaseLocation";
		break;
	case TaskGoalType::Burrow_And_Ambush_Attack_With_Lurker: str = "Burrow_And_Ambush_Attack_With_Lurker";
		break;

	case TaskGoalType::TaskGoalType_Undefined: str = "TaskGoalType_Undefined";
		break;
	default: str = "???";
		break;
	}

	return str;
}

std::string StrategicTaskUtil::toString(StrategicTask task)
{
	std::string str = "";

	str = StrategicTaskUtil::getTaskGoalTypeString(task.taskGoal);
	str += " ";

	if (task.targetUnitType != BWAPI::UnitTypes::None){
		str += task.targetUnitType.getName();
		str += " ";
	}
	if (task.targetTechType != BWAPI::TechTypes::None) {
		str += task.targetTechType.getName();
		str += " ";
	}

	if (task.targetUpgradeType != BWAPI::UpgradeTypes::None){
		str += task.targetUpgradeType.getName();
		str += " ";
	}

	if (task.targetPosition != BWAPI::Positions::None) {
		str += std::to_string(task.targetPosition.x);
		str += ",";
		str += std::to_string(task.targetPosition.y);
		str += " ";
	}

	if (task.targetUnit != nullptr) {
		str += "ID= ";
		str += std::to_string(task.targetUnit->getID());
	}

	if (task.targetCount != 0) {
		str += std::to_string(task.targetCount);
	}
	
	return str;
}
