#pragma once

#include "Common.h"
#include "StrategyData.h"
#include "InformationManager.h"

namespace MyBot
{
	class Squad
	{
	public:
		Squad();
		~Squad();

		std::string			squadName;

		BWAPI::Unitset		unitset;			///< δ Ҽ ֵ

		Mission				commonMission;		///< δ  ǥ

		//int					state;				///< δ  ( ž, ̵,  ,  .   ̵. ؼ ӹ)

		/// Ʊ Unit  Mission   		
		std::map<BWAPI::Unit, Mission> unitMissionMap;

		/// Ʊ Unit   Unit   		
		/// Ʊ Unit 1  ִ  Unit 1  εȴ
		///  Unit 1  Ʊ Unit   ε  ִ
		std::map<BWAPI::Unit, BWAPI::Unit> unitTargetMap;

		/// Լ - unit  mission  ο
		void setUnitMission(BWAPI::Unit unit, Mission newMission);

		Mission* getUnitMission(BWAPI::Unit unit);

		void addUnit(BWAPI::Unit unit);

		void addUnitWithMission(BWAPI::Unit unit, Mission newMission);

		BWAPI::Unitset::iterator Squad::removeUnit(BWAPI::Unitset::iterator  it);

		void executeMission();

		int getCount(BWAPI::UnitType unitType);

		const bool operator == (const Squad & rhs) const
		{
			return (squadName.compare(rhs.squadName) == 0);
		}

		bool controlZergling(BWAPI::Unit myUnit);
		bool controlHydralisk(BWAPI::Unit myUnit);
		bool controlLurker(BWAPI::Unit myUnit);
		bool controlDefiler(BWAPI::Unit myUnit);
		bool controlQueen(BWAPI::Unit myUnit);
		bool controlScourge(BWAPI::Unit myUnit);
		bool controlMutalisk(BWAPI::Unit myUnit);
		bool controlGuardian(BWAPI::Unit myUnit);
		bool controlUltralisk(BWAPI::Unit myUnit);
		bool controlDevourer(BWAPI::Unit myUnit);
	};
}

