#include "Squad.h"

using namespace MyBot;

Squad::Squad()
{
}

Squad::~Squad()
{
}

void Squad::addUnit(BWAPI::Unit unit)
{
	addUnitWithMission(unit, commonMission);

}
void Squad::addUnitWithMission(BWAPI::Unit unit, Mission newMission)
{
	unitset.insert(unit);

	setUnitMission(unit, newMission);
}

BWAPI::Unitset::iterator Squad::removeUnit(BWAPI::Unitset::iterator  it)
{
	unitMissionMap.erase((*it));

	return unitset.erase(it);
}


int Squad::getCount(BWAPI::UnitType unitType)
{
	int result = 0;
	for (auto unit : unitset) {
		if (unit->getType() == unitType) {
			result++;
		}
	}
	return result;
}

void Squad::setUnitMission(BWAPI::Unit unit, Mission newMission)
{
	if (!unit) { return; }

	auto & it = unitMissionMap.find(unit);
	if (it == unitMissionMap.end())
	{
		unitMissionMap[unit] = newMission;

		/*
		std::cout << "setUnitMission " << unit->getType().getName() << " (" << unit->getID() << ") to " << newMission.missionType;
		if (newMission.targetUnit != nullptr) {
			std::cout << " targetUnit " << newMission.targetUnit->getType().getName() << " ID " << newMission.targetUnit->getID()
				<< " at " << newMission.targetUnit->getTilePosition().x << "," << newMission.targetUnit->getTilePosition().y;
		}
		if (newMission.targetPosition != BWAPI::Positions::None) {
			std::cout << " targetPosition " << newMission.targetPosition.x / TILE_SIZE << "," << newMission.targetPosition.y / TILE_SIZE;
		}
		std::cout << std::endl;
		*/
	}
	else {
		Mission & mission = unitMissionMap[unit];

		//  mission  ޶ ٲ۴
		if (mission.missionType != newMission.missionType
			|| mission.targetPosition != newMission.targetPosition
			|| mission.targetUnit != newMission.targetUnit)
		{
			mission.missionType = newMission.missionType;
			mission.targetPosition = newMission.targetPosition;
			mission.targetUnit = newMission.targetUnit;

			mission.missionSetFrame = BWAPI::Broodwar->getFrameCount();


			/*
			std::cout << "setUnitMission " << unit->getType().getName() << " (" << unit->getID() << ") to " << newMission.missionType;
			if (newMission.targetUnit != nullptr) {
				std::cout << " targetUnit " << newMission.targetUnit->getType().getName() << " ID " << newMission.targetUnit->getID()
					<< " at " << newMission.targetUnit->getTilePosition().x << "," << newMission.targetUnit->getTilePosition().y;
			}
			if (newMission.targetPosition != BWAPI::Positions::None) {
				std::cout << " targetPosition " << newMission.targetPosition.x / TILE_SIZE << "," << newMission.targetPosition.y / TILE_SIZE;
			}
			std::cout << std::endl;
			*/
		}
	}
}

Mission* Squad::getUnitMission(BWAPI::Unit unit)
{
	auto & it = unitMissionMap.find(unit);
	if (it == unitMissionMap.end())
	{
		unitMissionMap[unit] = Mission();
	}

	return &(unitMissionMap[unit]);
}

void Squad::executeMission()
{
	// ,    ǹ ǹ  Ѵ
	for (auto it = unitset.begin(); it != unitset.end(); ) {
		BWAPI::Unit myUnit = *it;
		if (myUnit == nullptr || myUnit->exists() == false || myUnit->getHitPoints() <= 0 || myUnit->getType().isBuilding()) {
			it = unitset.erase(it);
		}
		else {
			++it;
		}
	}

	// Żũ δ뿡 ε, Żũ, , ٰ ƴ  Ѵ
	if (squadName.compare("mainCombatMutaliskSquad") == 0) {
		for (auto it = unitset.begin(); it != unitset.end();) {
			BWAPI::Unit myUnit = *it;
			if (myUnit->getType() == BWAPI::UnitTypes::Zerg_Mutalisk
				|| myUnit->getType() == BWAPI::UnitTypes::Zerg_Scourge
				|| myUnit->getType() == BWAPI::UnitTypes::Zerg_Cocoon
				|| myUnit->getType() == BWAPI::UnitTypes::Zerg_Guardian
				|| myUnit->getType() == BWAPI::UnitTypes::Zerg_Devourer
				|| myUnit->getType() == BWAPI::UnitTypes::Zerg_Larva
				|| myUnit->getType() == BWAPI::UnitTypes::Zerg_Egg
				|| myUnit->getType() == BWAPI::UnitTypes::Zerg_Overlord)
			{
				++it;
			}
			else {
				it = unitset.erase(it);
			}
		}
	}

	for (auto it = unitMissionMap.begin(); it != unitMissionMap.end();) {
		BWAPI::Unit myUnit = (*it).first;
		if (myUnit == nullptr || myUnit->exists() == false || myUnit->getHitPoints() <= 0) {
			it = unitMissionMap.erase(it);
		}
		else {
			++it;
		}
	}

	for (auto it = unitTargetMap.begin(); it != unitTargetMap.end();) {
		BWAPI::Unit enemyUnit = (*it).first;
		BWAPI::Unit myUnit = (*it).second;
		if (enemyUnit == nullptr || enemyUnit->exists() == false || enemyUnit->getHitPoints() <= 0
			|| myUnit == nullptr || myUnit->exists() == false || myUnit->getHitPoints() <= 0) 
		{
			it = unitTargetMap.erase(it);
		}
		else {
			++it;
		}
	}

	for (auto & myUnit : unitset) {
		Mission* unitMission = getUnitMission(myUnit);

		std::map<BWAPI::Unit, UnitInfo> & unitAndUnitInfoMap = InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().selfPlayer);
		auto & it = unitAndUnitInfoMap.find(myUnit);
		if (it != unitAndUnitInfoMap.end()) {

			UnitInfo& unitInfo = it->second;

			if (unitMission->missionType == MissionType::Move) {
				if (unitMission->targetPosition != BWAPI::Positions::None) {

					//  ̼ 
					if (myUnit->getDistance(unitMission->targetPosition) < 3 * TILE_SIZE) {
						unitMission->missionType = MissionType::Mission_Undefined;
					}
					else if (myUnit->isBurrowed()) {
						myUnit->unburrow();
					}
					else {

						// TODO : ̵  ޾, , ε  ݴɷ µ   ְų ݹް  ̵θ ؾ Ѵ
						// ε   쿡 ٸ ̼ ó
						/*
						if (myUnit->getType() == BWAPI::UnitTypes::Zerg_Overlord)
						{
							for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer)) {
								BWAPI::Unit enemyUnit = it.first;
								UnitInfo & enemyUnitInfo = it.second;

								if (enemyUnitInfo.type.canAttack()
									&& enemyUnitInfo.type.airWeapon() != BWAPI::WeaponTypes::None
									&& enemyUnitInfo.type.isWorker() == false)
								{
									if (enemyUnitInfo.lastPosition.getDistance(myUnit->getPosition()) <= enemyUnitInfo.type.airWeapon().maxRange() + 3 * TILE_SIZE) {

										CommandUtil::move(myUnit, BWAPI::Position(unitMission->targetPosition.x + 100, unitMission->targetPosition.y + 100));
									}
								}
							}

						}
						else {
						*/
							CommandUtil::move(myUnit, unitMission->targetPosition);
						//}


					}

				}
			}
			else if (unitMission->missionType == MissionType::MovePoint) {
				if (unitMission->targetPosition != BWAPI::Positions::None) {

					//  ̼ 
					if (myUnit->getDistance(unitMission->targetPosition) < 1 * TILE_SIZE) {
						unitMission->missionType = MissionType::Mission_Undefined;
					}
					else {
						CommandUtil::move(myUnit, unitMission->targetPosition);
					}
				}
			}

			else if (unitMission->missionType == MissionType::Return_Home) {
				if (unitMission->targetPosition != BWAPI::Positions::None) {
					CommandUtil::move(myUnit, unitMission->targetPosition);
				}
			}
			else if (unitMission->missionType == MissionType::Wait) {
			}
			else if (unitMission->missionType == MissionType::Burrow) {
				if (myUnit->canBurrow() ) {
					if (myUnit->isBurrowed() == false) {
						myUnit->burrow();
					}
				}
			}
			else if (unitMission->missionType == MissionType::MoveAndHoldPosition) {
				//  ̼ 
				if (myUnit->getDistance(unitMission->targetPosition) < 0.5 * TILE_SIZE) {
					unitMission->missionType = MissionType::HoldPosition;
				}
				else {
					CommandUtil::move(myUnit, unitMission->targetPosition);
				}
			}
			else if (unitMission->missionType == MissionType::Attack) {

				bool hasCommanded = false;

				// Ϲ CommandUtil::attack δ  ״ Ͼ, ۸  ϲ  Ѵ
				//  ϲ Ȯϰ ̱ , ۸  ϲ ϴ 쿡 , unit->attack  Ѵ
				if (unitInfo.type == BWAPI::UnitTypes::Zerg_Zergling) {

					if (unitMission->targetUnit != nullptr && unitMission->targetUnit->isVisible() && unitMission->targetUnit->getHitPoints() > 0) {

						//  ϲ ̴ 쿡 unit->attack  Ѵ
						if (unitMission->targetUnit->getType().isWorker()) {

							// ƹ ϰ ־ų, ٸ  ϴٰ ó ϲ  ɹ 
							bool isFreezed = false;

							BWAPI::Order order = myUnit->getOrder();

							//  Ȳΰ:
							//
							// isIdle() == false && isMoving() = true && isAccelerating() = true 
							// isIdle() == true && isMoving() = false && isAccelerating() = false   Դٰϰų
							//
							// isIdle() == false && isMoving() = true && isAccelerating() = true  ӵ
							//
							// ġ  
							// 
							if (myUnit->isMoving() == true 
								&& myUnit->isAccelerating() == true
								&& unitInfo.positionBefore == myUnit->getPosition()
								&& BWAPI::Broodwar->getFrameCount() - unitInfo.positionBeforeRecordFrame >= 4			// 10Ӹ ϹǷ, ִ 9 ŭ   ȴ
								)
							{
								isFreezed = true;
							}
							
							//  Ȳ ƴϰ,  ̵ / ϰ ִٸ  
							if (isFreezed == false) {
								if (BWAPI::Broodwar->getFrameCount() % 10 == 0) {

									if (myUnit->isAttacking() == false) {
										myUnit->attack(unitMission->targetUnit);
									}
								}
							}
							// Ƽ ִ Ȳ̶,   Ǭ
							else {

								// ó  ҷ move ؾ  Ǯ 
								// Stop ̳ HoldPosition δ    Ǯ
								
								if (myUnit->getLastCommand().getType() != BWAPI::UnitCommandTypes::Stop && myUnit->getLastCommand().getType() != BWAPI::UnitCommandTypes::Hold_Position)
								{
									myUnit->stop();
									//std::cout << "stop " << std::endl;
								}
								if (myUnit->getLastCommand().getType() == BWAPI::UnitCommandTypes::Stop)
								{
									myUnit->holdPosition();
									//std::cout << "holdPosition " << std::endl;
								}
								if (myUnit->getLastCommand().getType() == BWAPI::UnitCommandTypes::Hold_Position)
								{
									CommandUtil::move(myUnit, unitMission->targetUnit->getPosition());
									//std::cout << "move " << std::endl;
								}
							}
						}
						// Ϲ 쿡 CommandUtil::attackUnit  Ѵ
						else {
							CommandUtil::attackUnit(myUnit, unitMission->targetUnit);
						}
					}
					else {
						UnitAndUnitInfoMap & enemyUnitAndUnitInfoMap = InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer);
						if (enemyUnitAndUnitInfoMap.find(unitMission->targetUnit) != enemyUnitAndUnitInfoMap.end()) {
							UnitInfo& enemyUnitInfo = enemyUnitAndUnitInfoMap.find(unitMission->targetUnit)->second;

							CommandUtil::attackMove(myUnit, enemyUnitInfo.lastPosition);
						}					
					}
				}
				// 
				else if (myUnit->getType() == BWAPI::UnitTypes::Zerg_Hydralisk) {

					hasCommanded = controlHydralisk(myUnit);

					if (hasCommanded == false) {
						if (unitMission->targetUnit != nullptr && unitMission->targetUnit->isVisible() && unitMission->targetUnit->getHitPoints() > 0) {
							CommandUtil::attackUnit(myUnit, unitMission->targetUnit);
						}
						else {
							// TODO : targetPosition ? enemyUnitInfo.lastPosition
							//UnitInfo& enemyUnitInfo = InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer).find(unitMission->targetUnit)->second;
							//CommandUtil::move(myUnit, unitMission->targetPosition);
						}
					}
				}
				// Ŀ
				else if (myUnit->getType() == BWAPI::UnitTypes::Zerg_Lurker) {

					hasCommanded = controlLurker(myUnit);

					if (hasCommanded == false) {
						if (unitMission->targetUnit != nullptr && unitMission->targetUnit->isVisible() && unitMission->targetUnit->getHitPoints() > 0) {
							CommandUtil::attackUnit(myUnit, unitMission->targetUnit);
						}
						else {
							// TODO : targetPosition ? enemyUnitInfo.lastPosition
							//UnitInfo& enemyUnitInfo = InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer).find(unitMission->targetUnit)->second;
							//CommandUtil::move(myUnit, unitMission->targetPosition);
						}
					}
				}
				// ׷   ׳ 
				else {
					if (unitMission->targetUnit != nullptr && unitMission->targetUnit->isVisible() && unitMission->targetUnit->getHitPoints() > 0) {
						CommandUtil::attackUnit(myUnit, unitMission->targetUnit);
					}
					else {
						// TODO : targetPosition ? enemyUnitInfo.lastPosition
						//UnitInfo& enemyUnitInfo = InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer).find(unitMission->targetUnit)->second;
						//CommandUtil::attackMove(myUnit, unitMission->targetPosition);
					}
				}
			}
			else if (unitMission->missionType == MissionType::AttackMove) {

				bool hasCommanded = false;

				// Ŀ
				if (myUnit->getType() == BWAPI::UnitTypes::Zerg_Lurker) {

					hasCommanded = controlLurker(myUnit);

					if (hasCommanded == false) {
						if (myUnit->isBurrowed() == true && unitMission->targetUnit != nullptr && unitMission->targetUnit->isVisible() && unitMission->targetUnit->getHitPoints() > 0) {
							CommandUtil::attackUnit(myUnit, unitMission->targetUnit);
							hasCommanded = true;
						}
						else if (myUnit->isBurrowed() == false && unitMission->targetPosition != BWAPI::Positions::None) {
							CommandUtil::move(myUnit, unitMission->targetPosition);
							hasCommanded = true;
						}
					}
				}
				// Ϸ
				else if (myUnit->getType() == BWAPI::UnitTypes::Zerg_Defiler) {

					hasCommanded = controlDefiler(myUnit);

					if (hasCommanded == false) {
						if (myUnit->isBurrowed() == false && unitMission->targetPosition != BWAPI::Positions::None) {
							CommandUtil::move(myUnit, unitMission->targetPosition);
							hasCommanded = true;
						}
					}
				}
				// 
				else if (myUnit->getType() == BWAPI::UnitTypes::Zerg_Queen) {

					hasCommanded = controlQueen(myUnit);

					if (hasCommanded == false) {
						if (myUnit->isBurrowed() == false && unitMission->targetPosition != BWAPI::Positions::None) {
							CommandUtil::move(myUnit, unitMission->targetPosition);
							hasCommanded = true;
						}
					}
				}
				else if (myUnit->getType().canAttack()) {

					if (unitMission->targetUnit != nullptr && unitMission->targetUnit->exists() && unitMission->targetUnit->getHitPoints() > 0) {
						CommandUtil::attackUnit(myUnit, unitMission->targetUnit);
					}
					else if (unitMission->targetPosition != BWAPI::Positions::None) {

						//  ̼ 
						if (myUnit->getDistance(unitMission->targetPosition) < 3 * TILE_SIZE) {
							unitMission->missionType = MissionType::Mission_Undefined;
						}
						else {
							CommandUtil::attackMove(myUnit, unitMission->targetPosition);
						}
					}

				}
				// TODO : ε, , Ϸ  canAttack ϴ  ׳ ȥ ռ  
				else {
					if (unitMission->targetPosition != BWAPI::Positions::None) {

						//  ̼ 
						if (myUnit->getDistance(unitMission->targetPosition) < 3 * TILE_SIZE) {
							unitMission->missionType = MissionType::Mission_Undefined;
						}
						else {
							CommandUtil::move(myUnit, unitMission->targetPosition);
						}
					}
				}
			}
			else if (unitMission->missionType == MissionType::HoldPosition) {
				if (myUnit->isHoldingPosition() == false) {
					myUnit->holdPosition();
				}
			}
			else if (unitMission->missionType == MissionType::Stop) {
				if (myUnit->isIdle() == false) {
					myUnit->stop();
				}
			}
		}
	}
}


bool Squad::controlHydralisk(BWAPI::Unit myUnit)
{
	Mission* unitMission = getUnitMission(myUnit);
	bool hasCommanded = false;

	double tempDistance = 0;

	return hasCommanded;
}

bool Squad::controlLurker(BWAPI::Unit myUnit)
{
	Mission* unitMission = getUnitMission(myUnit);
	bool hasCommanded = false;
	bool isToUseStopLurker = false;
	BWAPI::Position destinationPosition;

	double tempDistance = 0;

	// ó Ŀ ݰ   ִ°?
	BWAPI::Position nearEnemyUnitPosition = BWAPI::Positions::None;
	// ó Ŀ ݰ   ִ°?
	BWAPI::Position nearUnwinnableEnemyUnitPosition = BWAPI::Positions::None;

	for (BWAPI::Unit enemyUnit : BWAPI::Broodwar->enemy()->getUnits()) {
		if (enemyUnit == nullptr || enemyUnit->exists() == false) continue;

		tempDistance = myUnit->getDistance(enemyUnit->getPosition());

		// TODO :   ֿ    ο?
		if (tempDistance <= 6 * TILE_SIZE
			&& enemyUnit->isFlying() == false)		
		{
			nearEnemyUnitPosition = enemyUnit->getPosition();
		}

		if (tempDistance <= 8 * TILE_SIZE) {
			if (enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Carrier
				|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Scout
				|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Wraith
				|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Battlecruiser
				|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Science_Vessel
				|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Mutalisk
				|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Guardian
				) 
			{
				nearUnwinnableEnemyUnitPosition = enemyUnit->getPosition();
			}
		}
	}

	for (BWAPI::Unit enemyUnit : BWAPI::Broodwar->enemy()->getUnits()) {
		if (enemyUnit == nullptr || enemyUnit->exists() == false) continue;

		if (enemyUnit->isFlying()) continue;

		tempDistance = myUnit->getDistance(enemyUnit->getPosition());
		// TODO :  ֿ    ο
		if (tempDistance <= 6 * TILE_SIZE) {
			nearEnemyUnitPosition = enemyUnit->getPosition();
		}
	}


	//  ߴ°?
	bool isArrived = false;
	if (unitMission->missionType == MissionType::AttackMove || unitMission->missionType == MissionType::Move) {
		destinationPosition = unitMission->targetPosition;
		if (destinationPosition != BWAPI::Positions::None) {

			//  ó  ο
			// Ȯ ǿ    ֱ 
			if (myUnit->getDistance(destinationPosition) < 4 * TILE_SIZE) {
				isArrived = true;
			}
		}
	}
	else if (unitMission->missionType == MissionType::Attack) {
		if (unitMission->targetUnit != nullptr) {

			if (unitMission->targetUnit->getPosition().isValid()){
				//  ó  ο
				// Ȯ ǿ    ֱ 
				if (myUnit->getDistance(unitMission->targetUnit->getPosition()) < 4 * TILE_SIZE) {
					isArrived = true;
				}
			}
		}
	}

	// ο Ǿ  ¿
	if (myUnit->isBurrowed() == false) {

		//   , ó    ο Ų
		//   ƴ 쿡 ó   ־ ο Ű ʴ´
		if (unitMission->missionType == MissionType::AttackMove || unitMission->missionType == MissionType::Attack) {

			if (nearEnemyUnitPosition != BWAPI::Positions::None) {
				myUnit->burrow();
				hasCommanded = true;
			}
		}

		//   ο Ų
		if (isArrived == true) {
			myUnit->burrow();
			hasCommanded = true;
		}
	}
	// ο Ǿִ ¿
	else {

		//    
		if (unitMission->missionType == MissionType::AttackMove || unitMission->missionType == MissionType::Attack) {

			//   ֵ, οǾִµ,  Ÿ  ó 
			if (nearEnemyUnitPosition != BWAPI::Positions::None) {

				// žĿ :  Ʊ   path ߰ ź ѳ ambush Lurker  .  
				// TODO : ׶  ũ, 佺 ÷,  (ε  ) ۸ / Ϸ 
				if (isToUseStopLurker) {

					int enemyGroundUnitCount = 0;
					int enemyDetectorUnitCount = 0;
					int myLurkerUnitCount = 0;
					int myOtherAttackUnitCount = 0;
					for (auto & enemyUnit : BWAPI::Broodwar->enemy()->getUnits()) {
						if (enemyUnit == nullptr || enemyUnit->exists() == false) continue;

						// Ŀ Ÿ : 6
						if (enemyUnit->getType().isFlyer() == false && enemyUnit->getDistance(myUnit) <= 6 * TILE_SIZE) {
							enemyGroundUnitCount++;
						}
						// ̾  : 10
						//  : 9 + 2
						// ε : 9 + 2
						if (enemyUnit->getType().isDetector() == true && enemyUnit->getDistance(myUnit) < enemyUnit->getType().sightRange() * TILE_SIZE) {
							enemyDetectorUnitCount++;
						}
					}
					for (auto & myFriendUnit : BWAPI::Broodwar->self()->getUnits()) {

						if (myFriendUnit == nullptr || myFriendUnit->exists() == false) continue;

						if (myFriendUnit->getType() == BWAPI::UnitTypes::Zerg_Lurker && myUnit->getPosition().getDistance(myFriendUnit->getPosition()) < 6 * TILE_SIZE) {
							myLurkerUnitCount++;
						}
						else if (myFriendUnit->getType().canAttack() && myFriendUnit->getType().isWorker() == false && myFriendUnit->getDistance(myUnit) < 6 * TILE_SIZE) {
							myOtherAttackUnitCount++;
						}
					}

					std::cout << "Lurker " << myUnit->getID()
						<< " myLurkerUnitCount " << myLurkerUnitCount
						<< " myOtherAttackUnitCount " << myOtherAttackUnitCount
						<< " enemyGroundUnitCount " << enemyGroundUnitCount
						<< std::endl;


					// Ŀ 3 ̻  ְ,   Ž ,  Ʊ   ź ȿ ߻. ž Ŀ .
					//  ݰ    4 ̻ ɶ  ִ´
					if (myLurkerUnitCount >= 3 && enemyDetectorUnitCount == 0 && myOtherAttackUnitCount == 0) {
						if (enemyGroundUnitCount < 4) {
							myUnit->stop();
							std::cout << "Stop Lurker " << myUnit->getID() << std::endl;
							hasCommanded = true;
						}
					}
				}

				// TODO :     ִ ,   Ѵ
				if (hasCommanded == false) {
					
					// ϴ  켱    Ѵ
					for (auto & enemyUnit : BWAPI::Broodwar->enemy()->getUnits()) {
						if (enemyUnit == nullptr || enemyUnit->exists() == false) continue;
						if (enemyUnit->getType().isFlyer() == false && enemyUnit->getDistance(myUnit) <= 6 * TILE_SIZE) {
							// 
							if (enemyUnit->getType() == BWAPI::UnitTypes::Protoss_High_Templar
								|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Archon
								|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Dark_Templar
								|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Dark_Archon
								|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Medic
								|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode
								|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode
								|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Ghost
								|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Lurker
								|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Defiler
								) 
							{
								CommandUtil::attackUnit(myUnit, enemyUnit);
								break;
							}
						}
					}
				}
			}
			// Ÿ   /   (ex: ũ)  κ Ϲ °  ο Ų
			else if (nearUnwinnableEnemyUnitPosition != BWAPI::Positions::None) {
				myUnit->unburrow();
				hasCommanded = true;
			}
			// ó    
			else {
				// κ ָ, ο Ѽ  ̵ ϰ Ѵ
				if (isArrived == false) {
					if (nearEnemyUnitPosition == BWAPI::Positions::None) {
						myUnit->unburrow();
						hasCommanded = true;
					}
				}
			}
		}
		// ̵  , κ ָ ο Ų
		else {
			if (isArrived == false) {
				myUnit->unburrow();
				hasCommanded = true;
			}
		}
	}

	return hasCommanded;

}

bool Squad::controlQueen(BWAPI::Unit myUnit)
{

	if (myUnit == nullptr || myUnit->exists() == false) {
		return false;
	}

	Mission* unitMission = getUnitMission(myUnit);
	bool hasCommanded = false;

	BWAPI::Position destinationPosition;

	double tempDistance = 0;
	
	if (hasCommanded == false) {
		if (myUnit->getEnergy() >= BWAPI::TechTypes::Spawn_Broodlings.energyCost()) {

			// ó  ÷, ũ, Ϸ, Ŀ ִ°
			BWAPI::Position nearEnemyUnitPosition;

			for (BWAPI::Unit enemyUnit : BWAPI::Broodwar->enemy()->getUnits()) {
				if (enemyUnit == nullptr || enemyUnit->exists() == false) continue;

				if (enemyUnit->getType() == BWAPI::UnitTypes::Protoss_High_Templar
					|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode
					|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode
					|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Defiler
					|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Lurker
					//|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Ultralisk
					) {
					tempDistance = myUnit->getDistance(enemyUnit->getPosition());
					//if (tempDistance <= 11 * TILE_SIZE)
					{
						nearEnemyUnitPosition = enemyUnit->getPosition();

						myUnit->useTech(BWAPI::TechTypes::Plague, nearEnemyUnitPosition);
						hasCommanded = true;
					}
				}
			}
		}
	}

	if (hasCommanded == false) {
		if (myUnit->getEnergy() >= BWAPI::TechTypes::Parasite.energyCost()) {

			// ó   Ʋ ִ°
			BWAPI::Position nearEnemyUnitPosition;

			for (BWAPI::Unit enemyUnit : BWAPI::Broodwar->enemy()->getUnits()) {
				if (enemyUnit == nullptr || enemyUnit->exists() == false) continue;

				if (enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Shuttle
					|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Observer
					//|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Corsair
					//|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Carrier
					//|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Arbiter
					//|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Science_Vessel
					|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Dropship
					//|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Battlecruiser
					|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Overlord
					//|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Lurker
					//|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Defiler
					//|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Queen
					//|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Ultralisk
					) {
					if (enemyUnit->isParasited() == false) {
						tempDistance = myUnit->getDistance(enemyUnit->getPosition());
						//if (tempDistance <= 11 * TILE_SIZE)
						{
							nearEnemyUnitPosition = enemyUnit->getPosition();

							myUnit->useTech(BWAPI::TechTypes::Parasite, nearEnemyUnitPosition);
							hasCommanded = true;
						}
					}
				}
			}
		}
	}

	/*
	if (hasCommanded == false) {
		if (myUnit->getEnergy() >= BWAPI::TechTypes::Ensnare.energyCost()) {

			// ó  Ŀ  ִ°
			BWAPI::Position nearEnemyUnitPosition;

			for (BWAPI::Unit enemyUnit : BWAPI::Broodwar->enemy()->getUnits()) {
				if (enemyUnit == nullptr || enemyUnit->exists() == false) continue;

				if (enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Corsair
					|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Carrier
					//|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Probe
					|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Zealot
					//|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_SCV
					//|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Marine
					|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Wraith
					|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Battlecruiser
					//|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Drone
					//|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Zergling
					|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Hydralisk
					|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Mutalisk
					//|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Devourer
					//|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Scourge
					) {
					if (enemyUnit->isPlagued() == false) {
						tempDistance = myUnit->getDistance(enemyUnit->getPosition());
						if (tempDistance <= 11 * TILE_SIZE)
						{
							nearEnemyUnitPosition = enemyUnit->getPosition();

							myUnit->useTech(BWAPI::TechTypes::Ensnare, nearEnemyUnitPosition);
							hasCommanded = true;
						}
					}
				}
			}
		}
	}
	*/

	return hasCommanded;
}

bool Squad::controlDefiler(BWAPI::Unit myUnit)
{
	if (myUnit == nullptr || myUnit->exists() == false) {
		return false;
	}

	Mission* unitMission = getUnitMission(myUnit);
	bool hasCommanded = false;

	BWAPI::Position destinationPosition;

	double tempDistance = 0;

	//  ,   ۸  Ѵ
	if (BWAPI::Broodwar->self()->hasResearched(BWAPI::TechTypes::Consume)) {

		if (myUnit->getEnergy() < 150) {
			double minDistance = 1000000000;
			BWAPI::Unit targetZergling = nullptr;
			for (BWAPI::Unit zerglingUnit : BWAPI::Broodwar->self()->getUnits()) {
				if (zerglingUnit == nullptr || zerglingUnit->exists() == false) continue;

				if (zerglingUnit->getType() == BWAPI::UnitTypes::Zerg_Zergling) {
					tempDistance = myUnit->getDistance(zerglingUnit->getPosition());

					if (minDistance > tempDistance) {
						minDistance = tempDistance;
						targetZergling = zerglingUnit;
					}
				}
			}

			if (targetZergling != nullptr) {
				myUnit->useTech(BWAPI::TechTypes::Consume, targetZergling);
				hasCommanded = true;
			}
		}
	}

	if (hasCommanded == false) {
		if (myUnit->getEnergy() >= BWAPI::TechTypes::Dark_Swarm.energyCost()) {

			// ó Ʊ Ŀ οǾִ°?
			BWAPI::Position nearMyLurkerBurrowedPosition;

			for (BWAPI::Unit friendUnit : BWAPI::Broodwar->self()->getUnits()) {
				if (friendUnit == nullptr || friendUnit->exists() == false) continue;

				if (friendUnit->getType() == BWAPI::UnitTypes::Zerg_Lurker) {
					if (friendUnit->isBurrowed() && friendUnit->isUnderDarkSwarm() == false) {
						tempDistance = myUnit->getDistance(friendUnit->getPosition());
						//if (tempDistance <= 11 * TILE_SIZE)
						{
							nearMyLurkerBurrowedPosition = friendUnit->getPosition();

							myUnit->useTech(BWAPI::TechTypes::Dark_Swarm, nearMyLurkerBurrowedPosition);
							hasCommanded = true;
						}
					}
				}
			}
		}
	}

	if (hasCommanded == false) {
		if (myUnit->getEnergy() >= BWAPI::TechTypes::Plague.energyCost()) {

			// ó  Ŀ ĳ ִ°
			BWAPI::Position nearEnemyUnitPosition;

			for (BWAPI::Unit enemyUnit : BWAPI::Broodwar->enemy()->getUnits()) {
				if (enemyUnit == nullptr || enemyUnit->exists() == false) continue;

				if (enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Carrier
					|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Observer
					|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Arbiter
					|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Science_Vessel
					|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Battlecruiser
					|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Wraith
					|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Bunker
					|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Mutalisk
					|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Devourer
					) {
					if (enemyUnit->isPlagued() == false) {
						tempDistance = myUnit->getDistance(enemyUnit->getPosition());
						//if (tempDistance <= 11 * TILE_SIZE)
						{
							nearEnemyUnitPosition = enemyUnit->getPosition();

							myUnit->useTech(BWAPI::TechTypes::Plague, nearEnemyUnitPosition);
							hasCommanded = true;
						}
					}
				}
			}
		}
	}

	return hasCommanded;
}

bool Squad::controlScourge(BWAPI::Unit myUnit)
{
	if (myUnit == nullptr || myUnit->exists() == false) {
		return false;
	}

	Mission* unitMission = getUnitMission(myUnit);
	bool hasCommanded = false;

	for (auto & enemyUnit : BWAPI::Broodwar->enemy()->getUnits()) {
		if (enemyUnit == nullptr || enemyUnit->exists() == false) continue;
		if (enemyUnit->getType().isFlyer()) {

			if (enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Corsair
				|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Observer
				|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Shuttle
				|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Carrier
				|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Arbiter
				|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Dropship
				|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Science_Vessel
				|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Wraith
				|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Valkyrie
				|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Battlecruiser
				|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Overlord
				|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Mutalisk
				|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Guardian
				|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Devourer
				)
			{
				int numAirAttackableUnit = 0;
				for (auto & enemyAroundUnit : BWAPI::Broodwar->getUnitsInRadius(enemyUnit->getPosition(), 8 * TILE_SIZE)) {
					if (enemyAroundUnit == nullptr || enemyAroundUnit->exists() == false) continue;

					if (enemyAroundUnit->getType().airWeapon() != BWAPI::WeaponTypes::None) {
						numAirAttackableUnit++;
					}
				}
				if (numAirAttackableUnit < 6) {
					CommandUtil::attackUnit(myUnit, enemyUnit);
				}
				break;
			}
		}
	}

	return hasCommanded;
}

bool Squad::controlMutalisk(BWAPI::Unit myUnit)
{
	if (myUnit == nullptr || myUnit->exists() == false) {
		return false;
	}

	Mission* unitMission = getUnitMission(myUnit);
	bool hasCommanded = false;

	return hasCommanded;
}

bool Squad::controlGuardian(BWAPI::Unit myUnit)
{
	if (myUnit == nullptr || myUnit->exists() == false) {
		return false;
	}

	Mission* unitMission = getUnitMission(myUnit);
	bool hasCommanded = false;

	return hasCommanded;
}

bool Squad::controlUltralisk(BWAPI::Unit myUnit)
{
	if (myUnit == nullptr || myUnit->exists() == false) {
		return false;
	}

	Mission* unitMission = getUnitMission(myUnit);
	bool hasCommanded = false;

	return hasCommanded;
}

bool Squad::controlDevourer(BWAPI::Unit myUnit)
{
	if (myUnit == nullptr || myUnit->exists() == false) {
		return false;
	}

	Mission* unitMission = getUnitMission(myUnit);
	bool hasCommanded = false;

	return hasCommanded;
}

