/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.unitgroups;

import com.tyr.BWTAProxy;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.SpaceManager;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.BaseLocation;


/**
 * This unit group sends out a group of tanks to attack the enemy.
 * This unit group is no longer used.
 * @author Simon
 *
 */
public class TankForce extends UnitGroup 
{
	/**
	 * The position where we will attack.
	 */
	private Position target = null;
	
	/**
	 * This unit group sends out a group of tanks to attack the enemy.
	 * This unit group is no longer used.
	 * @param rejects The OutOfJob object to which units are sent which are no longer needed.
	 */
	public TankForce(OutOfJob rejects)
	{
		super(rejects);
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot)
	{
		if(BWTAProxy.initialized)
		{
			acquireTarget();
			if(target == null)
			{
				if(Settings.getRallyPoint() != null)
					target = Settings.getRallyPoint();
				else
					target = SpaceManager.getMainExit();
			}
			
			for(Agent agent : units)
			{
				agent.drawCircle(Color.Yellow);
				
				if(agent.unit.isIdle() || game.getFrameCount() % 200 == 0)
					agent.unit.attack(target);
				

				boolean targetExists = false;
				int radius = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange();
				for(Unit unit : EnemyManager.getEnemyUnits())
				{
					if (unit.getType().isFlyer() || unit.isLifted())
						continue;
					if (agent.distanceSquared(unit) <= radius * radius)
					{
						targetExists = true;
						break;
						
					}
				}
				
				if(agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode)
				{
					
					if (targetExists)
						agent.unit.siege();
				}
				else if (agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode)
				{
					if(!targetExists)
						agent.unit.unsiege();
				}
			}
		}
	}
	
	/**
	 * Find a new target to attack.
	 */
	public void acquireTarget()
	{
		target = null;
    	for(EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory)
    	{
    		target = p.pos;
    		break;
    	}

    	if (target == null)
    		for (BaseLocation b : Tyr.bot.suspectedEnemy) 
    		{
    			target = b.getPosition();
    			break;
    		}
	}
	
	@Override
	public void add(Agent agent)
	{
		super.add(agent);
	}
}
