/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import com.tyr.BWTAProxy;
import com.tyr.Tyr;
import com.tyr.agents.Agent;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;


/**
 * A task that constantly pushes the opponent.
 */
public class ZealotDropTask extends Task
{
	@Override
	public boolean isRequired(Game game, Player self, Tyr bot) 
	{
		return true;
	}
	
	@Override
	public void solve(Game game, Player self, Tyr bot)
	{
		// If we find a new target to attack, we set that new target.
		if (!BWTAProxy.initialized)
			return;
		
		int shuttlesNeeded = 1;
		int zealotsNeeded = 4;
		
		for(int i = bot.homeGroup.units.size() - 1; i >= 0; i--)
		{
			Agent agent = bot.homeGroup.units.get(i);

			if (agent.unit.getType() == UnitType.Protoss_Shuttle)
			{
				if (shuttlesNeeded <= 0)
					continue;
				shuttlesNeeded--;
				((ZealotDropSolution)solution).add(agent);
				bot.homeGroup.units.remove(i);
			}
			
			if (agent.unit.getType() == UnitType.Protoss_Zealot)
			{
				if (zealotsNeeded <= 0)
					continue;
				zealotsNeeded--;
				((ZealotDropSolution)solution).add(agent);
				bot.homeGroup.units.remove(i);
			}
		}
		
		// We call the super class, which will send the units out to attack.
		super.solve(game, self, bot);
	}

	@Override
	public void findSolution(Game game, Player self, Tyr bot)
	{
		solution = new ZealotDropSolution(this, 1);
	}
}
