/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import com.tyr.agents.Agent;
import com.tyr.unitgroups.UnitGroup;

import bwapi.Position;


/**
 * An abstract solution for which a target can be set.
 * @author Simon
 *
 */
public abstract class TargetableSolution extends Solution 
{
	/**
	 * An abstract solution for which a target can be set.
	 * @param task The task which called this solution.
	 */
	public TargetableSolution(Task task)
	{
		super(task);
	}
	
	/**
	 * Set the new target for the attack.
	 * @param target The target where we are going to attack.
	 */
	public abstract void setTarget(Position target);

	/**
	 * Add an agent who will join the attack.
	 * @param unit The agent who will join the attack.
	 */
	public abstract void add(Agent unit);
	
	/**
	 * The number of units sent by this solution.
	 * @return The number of units sent by this solution.
	 */
	public abstract int getCount();

	/**
	 * This method is called when this solution is no longer needed.
	 * @param unitGroup The unit group to which we will add all the units.
	 */
	public abstract void done(UnitGroup group);

}
