/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import com.tyr.Tyr;
import com.tyr.agents.Agent;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;


/**
 * A task that constantly pushes the opponent.
 */
public class ClearMinesTask extends Task
{
	@Override
	public boolean isRequired(Game game, Player self, Tyr bot) 
	{
		return true;
	}
	
	@Override
	public void solve(Game game, Player self, Tyr bot)
	{
		for(int i = bot.homeGroup.units.size() - 1; i >= 0; i--)
		{
			Agent agent = bot.homeGroup.units.get(i);

			if (agent.unit.getType() == UnitType.Protoss_Observer && ((ClearMinesSolution)solution).needsObserver()
					|| agent.unit.getType() == UnitType.Protoss_Scout && ((ClearMinesSolution)solution).needsScout())
			{
				((ClearMinesSolution)solution).add(agent);
				bot.homeGroup.units.remove(i);
			}
		}
		
		// We call the super class, which will send the units out to attack.
		super.solve(game, self, bot);
	}

	@Override
	public void findSolution(Game game, Player self, Tyr bot)
	{
		solution = new ClearMinesSolution(this);
	}
}
