/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.unitgroups.BCGroup;

import bwapi.Game;
import bwapi.Player;

/**
 * This is a solution which manages all Battlecruisers, regardless of whether they are at home or attacking.
 * @author Simon
 *
 */
public class BCSolution extends Solution 
{
	/**
	 * The BCGroup that will manage the Battlecruisers.
	 */
	BCGroup bcs;
	
	/**
	 * This is a solution which manages all Battlecruisers, regardless of whether they are at home or attacking.
	 * @param task The task that created this solution.
	 */
	public BCSolution(Task task) 
	{
		super(task);
		
		this.bcs = new BCGroup(Tyr.bot.hobos);
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot)
	{
		bcs.cleanup();
		bcs.onFrame(game, self, bot);
	}

	/**
	 * Add a Battlecruiser to the managing BCGroup.
	 * @param unit The Battlecruiser to add.
	 */
	public void add(Agent unit)
	{
		bcs.add(unit);
	}
}
