/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.requirements;

import com.tyr.Tyr;
import com.tyr.UnitTracker;

import bwapi.UnitType;

/**
 * Has a certain number of units been created?
 * @author Simon
 *
 */
public class UnitRequirement implements Requirement 
{
	/**
	 * The type of building that is required.
	 */
	private UnitType type;
	
	/**
	 * The number of units that need to have been built.
	 */
	private int count;
	
	/**
	 * Does the building need to be finished, or is it enough for it to be constructing or for a BuildCommand to have been issued?
	 */
	private boolean finished;

	/**
	 * Has a certain number of units been created?
	 * @param type The type of building that is required.
	 * @param count The number of units that need to have been built.
	 * @param finished Does the building need to be finished, or is it enough for it to be constructing or for a BuildCommand to have been issued?
	 */
	public UnitRequirement(UnitType type, int count, boolean finished)
	{
		this.type = type;
		this.count = count;
		this.finished = finished;
	}
	
	/**
	 * Has a certain number of units been created?
	 * @param type The type of building that is required.
	 * @param count The number of units that need to have been built.
	 */
	public UnitRequirement(UnitType type, int count)
	{
		this(type, count, false);
	}
	
	/**
	 * Has a certain number of units been created?
	 * @param type The type of building that is required.
	 */
	public UnitRequirement(UnitType type)
	{
		this(type, 1, false);
	}
	
	@Override
	public boolean met()
	{
		// For tanks we count them in either mode.
		if (type == UnitType.Terran_Siege_Tank_Siege_Mode || type == UnitType.Terran_Siege_Tank_Tank_Mode)
		{
			if (finished)
				return Tyr.self.completedUnitCount(UnitType.Terran_Siege_Tank_Siege_Mode ) + Tyr.self.completedUnitCount(UnitType.Terran_Siege_Tank_Tank_Mode) >= count;
			else
				return UnitTracker.countTanks() >= count;
		}
		if (finished)
			return Tyr.self.completedUnitCount(type) >= count;
		else
			return UnitTracker.count(type) >= count;
	}
}
