/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.requirements;

import java.util.ArrayList;

/**
 * A disjunction of requirements.
 * @author Simon
 *
 */
public class DisjRequirement implements Requirement
{
	/**
	 * List of all requirements of which one should be met.
	 */
	private ArrayList<Requirement> requirements = new ArrayList<Requirement>();
	
	/**
	 * Adds the requirement to the list of requirements.
	 * Returns this DisjRequirement, to allow more requirements to be added.
	 * @param req Adds the requirement to the list of requirements.
	 * @return This DisjRequirement, to allow more requirements to be added.
	 */
	public DisjRequirement addRequirement(Requirement req)
	{
		requirements.add(req);
		return this;
	}
	
	@Override
	public boolean met()
	{
		for (Requirement req : requirements)
			if (req.met())
				return true;
		
		return false;
	}
}
