/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.unitgroups.ScoutGroup;

import bwapi.Game;
import bwapi.Player;
import bwapi.TechType;
import bwapi.UnitType;


public class TvT extends CompositeBuildOrder
{
	boolean attacked;

	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		Settings.setWorkersPerGas(2);
		
		
		this.add(new SupplyDepotPart());
		this.add(new WorkerScoutPart(1600));
		this.add(new ExpandPart());
		
		super.initialize(game, self, bot);
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot) 
	{
		super.onFrame(game, self, bot);
		
		if(!attacked && bot.homeGroup.units.size() >= Settings.getRequiredSize())
			attacked = true;
		
		if(bot.scout.opponentStrategy == ScoutGroup.defensive)
			Settings.setMaximumSize(40);
		
		//if we've the resources to build a barracks ...
		if (bot.getAvailableMinerals()>= 150 && (UnitTracker.count(UnitType.Terran_Barracks) < Math.min(UnitTracker.getCcCount() * 2, 10))) 
		{
			bot.spaceManager.build(UnitType.Terran_Barracks);
		}
		
		if(UnitTracker.getGeyserCount() > 0 && bot.getAvailableMinerals()>= 150 && UnitTracker.count(UnitType.Terran_Refinery) == 0 && UnitTracker.count(UnitType.Terran_Barracks) >= 4) 
		{
			bot.spaceManager.build(UnitType.Terran_Refinery);
		}
		
		if(bot.getAvailableMinerals()>= 125 && UnitTracker.count(UnitType.Terran_Refinery) > 0 && UnitTracker.count(UnitType.Terran_Engineering_Bay) < 1) 
		{
			bot.spaceManager.build(UnitType.Terran_Engineering_Bay);
		}
		
		if(bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 100
				&& UnitTracker.count(UnitType.Terran_Barracks) >= 1 && UnitTracker.count(UnitType.Terran_Factory) < 1)
		{
			bot.spaceManager.build(UnitType.Terran_Factory);
		}
		
		if (bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100
				&& UnitTracker.count(UnitType.Terran_Engineering_Bay) > 0
				&& UnitTracker.count(UnitType.Terran_Factory) > 0
				&& UnitTracker.count(UnitType.Terran_Starport) < 1
				&& UnitTracker.count(UnitType.Terran_Command_Center) >= 2)
		{
			bot.spaceManager.build(UnitType.Terran_Starport);
		}
		
		if (bot.getAvailableMinerals() >= 150 
				&& UnitTracker.count(UnitType.Terran_Barracks) != 0 && UnitTracker.count(UnitType.Terran_Refinery) != 0
				&& UnitTracker.count(UnitType.Terran_Academy) == 0)
		{
			bot.spaceManager.build(UnitType.Terran_Academy);
		}
		
		if (bot.getAvailableMinerals() >= 100 && attacked)
		{
			for(DefensiveStructures structures : bot.defensiveStructures)
			{
				int count = structures.getUnitCount(UnitType.Terran_Bunker);
				
				if(count < 1)
				{
		  			bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
		  			break;
				}
			}
		}
	}
	
	@Override 
	public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent)
	{
		if(super.overrideStructureOrder(game, self, bot, agent))
			return true;
		
		if(agent.unit.getType() == UnitType.Terran_Factory)
		{
			int neededTanks = 0;
			for(DefensiveStructures defPos : bot.defensiveStructures)
				if (!defPos.tooFar)
					neededTanks += Settings.getDefensiveTanks();
			
			if(agent.unit.getAddon() == null 
					&& bot.getAvailableMinerals() >= 50 && bot.getAvailableGas() >= 50)
				agent.unit.buildAddon(UnitType.Terran_Machine_Shop);
			else if(!agent.unit.isTraining() && bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100
					&& UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode)
						< neededTanks
					&& (UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) == 0 || self.hasResearched(TechType.Tank_Siege_Mode)))
				agent.unit.train(UnitType.Terran_Siege_Tank_Tank_Mode);
			return true;
		}
		return false;
	}

}
