/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.tasks.DropHarassTask;

import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import bwapi.UnitType;


public class TFastDetect extends CompositeBuildOrder
{
	BuildOrder contained;
	
	public TFastDetect(BuildOrder contained)
	{
		this.contained = contained;
	}
	
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{	
		if(contained != null)
			contained.initialize(game, self, bot);
		
		bot.taskManager.potentialTasks.add(new DropHarassTask());
		
		super.add(new WorkerScoutPart(800));
		
		super.initialize(game, self, bot);
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot) 
	{
		super.onFrame(game, self, bot);
		
		boolean coreExists = false;
		for(EnemyPosition building : EnemyManager.getManager().enemyBuildingMemory)
		{
			if (building.type == UnitType.Protoss_Cybernetics_Core)
			{
				coreExists = true;
				break;
			}
		}
		
		if(coreExists && bot.getAvailableMinerals()>= 125 && UnitTracker.count(UnitType.Terran_Engineering_Bay) < 1 && UnitTracker.count(UnitType.Terran_Bunker) >= 1) 
		{
			bot.spaceManager.build(UnitType.Terran_Engineering_Bay);
		}
		
		if (bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100
				&& UnitTracker.count(UnitType.Terran_Command_Center) >= 2 && UnitTracker.count(UnitType.Terran_Factory) >= 1 && UnitTracker.count(UnitType.Terran_Starport) == 0)
		{
			bot.spaceManager.build(UnitType.Terran_Starport);
		}
		
		if (coreExists && bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1)
		{
			for(DefensiveStructures structures : bot.defensiveStructures)
			{
				if (!(structures.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) < 128
						&& UnitTracker.count(UnitType.Terran_Factory) == 0))
					continue;
					
				
				int count = structures.getUnitCount(UnitType.Terran_Bunker);
				
				if(count < (game.enemy().getRace() == Race.Protoss?2:1))
				{
					bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
		  			break;
				}
			}
		}

		if(UnitTracker.count(UnitType.Terran_Engineering_Bay) >= 1 && bot.getAvailableMinerals() >= 75)
		{
			for(DefensiveStructures structures : bot.defensiveStructures)
			{
				int count = structures.getUnitCount(UnitType.Terran_Missile_Turret);
				
				if(count < 1 && structures.defences.size() > 0)
				{
					bot.spaceManager.buildDefensive(UnitType.Terran_Missile_Turret, structures);
		  			break;
				}
			}
		}
		
		if (bot.getAvailableMinerals() >= 150 
				&& UnitTracker.count(UnitType.Terran_Barracks) != 0 && UnitTracker.count(UnitType.Terran_Refinery) != 0
				&& UnitTracker.count(UnitType.Terran_Academy) == 0)
		{
			bot.spaceManager.build(UnitType.Terran_Academy);
		}
		
		contained.onFrame(game, self, bot);
	}

	@Override
	public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent)
	{
		if(super.overrideStructureOrder(game, self, bot, agent))
			return true;
		
		if (agent.unit.getType() == UnitType.Terran_Starport)
		{
			if (agent.unit.getAddon() == null 
					&& bot.getAvailableMinerals() >= 50 && bot.getAvailableGas() >= 50)
				agent.unit.buildAddon(UnitType.Terran_Control_Tower);
			else
			if (bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 100
				&& UnitTracker.count(UnitType.Terran_Dropship) < 1)
			{
				agent.unit.train(UnitType.Terran_Dropship);
			}
			return true;
		}
			if (agent.unit.getType() == UnitType.Terran_Factory)
		{
			if (bot.getAvailableMinerals() >= 100 && !agent.unit.isTraining() && 
					UnitTracker.count(UnitType.Terran_Vulture) <= 2*(UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode)))
			{
				agent.unit.train(UnitType.Terran_Vulture);
				return true;
			}
			else if(UnitTracker.count(UnitType.Terran_Armory) >= 1 && !agent.unit.isTraining()
				&& UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) 
					>= 8 + UnitTracker.count(UnitType.Terran_Goliath) 
				&& bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 50)
				{
					agent.unit.train(UnitType.Terran_Goliath);
					return true;
				}
		}
		
		return contained.overrideStructureOrder(game, self, bot, agent);
	}
}
