/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.unitgroups.ScoutGroup;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;


public class DefensiveBC extends CompositeBuildOrder
{
	GreedyBC greedy = new GreedyBC();
	
	int desiredBunkers = 1;
	boolean zealots = false;
	
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		Settings.setWorkersPerGas(3);
		greedy.initialize(game, self, bot);
		
		this.add(new SupplyDepotPart());
		this.add(new WorkerScoutPart(1600));
		
		super.initialize(game, self, bot);
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot) 
	{
		super.onFrame(game, self, bot);
		
		if(UnitTracker.count(UnitType.Terran_Bunker) >= desiredBunkers
				&& UnitTracker.count(UnitType.Terran_Factory) >= 1)
			greedy.onFrame(game, self, bot);
		
		if(!zealots && bot.scout.opponentStrategy == ScoutGroup.zealotPush)
		{
			zealots = true;
			desiredBunkers = 2;
		}

		if(zealots)
			Tyr.drawCircle(Tyr.tileToPosition(self.getStartLocation()), Color.Red);
		
		//if we've the resources to build a barracks ...
		if(bot.getAvailableMinerals()>= 150
				&& (UnitTracker.count(UnitType.Terran_Barracks) < desiredBunkers)) 
		{
			bot.spaceManager.build(UnitType.Terran_Barracks);
		}
		
		if(UnitTracker.getGeyserCount() > 0 && bot.getAvailableMinerals()>= 100 
				&& UnitTracker.count(UnitType.Terran_Refinery) == 0 
				&& UnitTracker.count(UnitType.Terran_Barracks) >= 1
				&& UnitTracker.count(UnitType.Terran_Bunker) >= desiredBunkers) 
		{
			bot.spaceManager.build(UnitType.Terran_Refinery);
		}
		
		if(bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 100
				&& UnitTracker.count(UnitType.Terran_Barracks) >= 1 && UnitTracker.count(UnitType.Terran_Factory) < 1)
		{
			bot.spaceManager.build(UnitType.Terran_Factory);
		}
		
		if (bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1)
		{
			for(DefensiveStructures structures : bot.defensiveStructures)
			{
				int count = structures.getUnitCount(UnitType.Terran_Bunker);
				
				if(count < (!structures.tooFar?(desiredBunkers):0))
				{
					bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
		  			break;
				}
			}
		}
	}

	@Override 
	public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent)
	{
		if (super.overrideStructureOrder(game, self, bot, agent))
			return true;
		return greedy.overrideStructureOrder(game, self, bot, agent);
	}
}
