/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.DebugMessages;
import com.tyr.Settings;
import com.tyr.StopWatch;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.CompactBuildSite;
import com.tyr.tasks.AttackRegroupSolution;
import com.tyr.tasks.DefendMainTask;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;


/**
 * Implements a build which counters a worker rush.
 * @author Simon
 *
 */
public class AntiWorkerRush extends BuildOrder
{
	/**
	 * Implements a build which counters a worker rush.
	 */
	public AntiWorkerRush()
	{}
	
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		Settings.setRequiredSize(10);
		Settings.setMaximumSize(60);
		
		DefendMainTask.workerRush = true;
		AttackRegroupSolution.focusWorkers = false;
		
		Settings.setLargeInvasionDist(320);
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot)
	{
		Settings.setWorkersPerGas(0);
		DebugMessages.addMessage("Going bio.");
		
		StopWatch watch = new StopWatch();
		long time;
		watch.start();
		
		// Build barracks as soon as possible and close to the main base to make them easier to defend.
		if (bot.getAvailableMinerals()>= 150
				&& (UnitTracker.count(UnitType.Terran_Barracks) < 3)
			)
		{
			bot.spaceManager.build(UnitType.Terran_Barracks, null, new CompactBuildSite());
		}
		
		if (self.supplyTotal() + UnitTracker.getSupplyConstructing() <= Math.min(400, self.supplyUsed() + 4)
				&& bot.getAvailableMinerals() >= 100
				)
			bot.spaceManager.build(UnitType.Terran_Supply_Depot, null, new CompactBuildSite());

		time = watch.time();
		if (time > 55)
			DebugMessages.addMessage("Bio tier 1 time: " + time);
	}

	@Override
	public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent)
	{
		if (agent.unit.getType() == UnitType.Terran_Command_Center)
		{
			// Be careful with the number of scvs we build.
			// We need the minerals to get marines up.
			if (bot.getAvailableMinerals() >= 50 && !agent.unit.isTraining() && UnitTracker.count(UnitType.Terran_SCV) < 12)
			{
				agent.unit.train(UnitType.Terran_SCV);
				return true;
			}
			if (UnitTracker.count(UnitType.Terran_Barracks) == 0 && bot.getAvailableMinerals() < 200)
				return true;
			if (UnitTracker.count(UnitType.Terran_Marine) < 2 && bot.getAvailableMinerals() < 100)
				return true;
			
			if (bot.getAvailableMinerals() >= 50 && !agent.unit.isTraining())
				agent.unit.train(UnitType.Terran_SCV);
			return true;
		}
		if (agent.unit.getType() == UnitType.Terran_Barracks)
		{
			if (!agent.unit.isTraining()
					&& bot.getAvailableMinerals() >= 50)
				agent.unit.train(UnitType.Terran_Marine);
		}
		
		return false;
	}
}
