/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.DebugMessages;
import com.tyr.Settings;
import com.tyr.StopWatch;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.requirements.ArmyRequirement;
import com.tyr.requirements.LinearMax;
import com.tyr.requirements.UnitRequirement;

import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import bwapi.TechType;
import bwapi.UnitType;
import bwapi.UpgradeType;


/**
 * A mech build designed to stop both the terran and protoss versions of tscmoo.
 * @author Simon
 *
 */
public class AntiMoo extends CompositeBuildOrder
{
	/**
	 * A mech build designed to stop both the terran and protoss versions of tscmoo.
	 */
	public AntiMoo()
	{}
	
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		Settings.setRequiredSize(game.enemy().getRace() == Race.Protoss?40:5);
		Settings.setMaximumSize(60);
		Settings.setWorkersPerGas(3);
		
		if (game.enemy().getRace() == Race.Protoss)
		{
			//bot.taskManager.potentialTasks.add(new BoomerangTask());
			/*
			bot.taskManager.potentialTasks.add(new VultureHarassTask(1));
			bot.taskManager.potentialTasks.add(new VultureHarassTask(-1));
			VultureHarassTask.desiredVultures = 3;*/
		}
		
		this.add(new SupplyDepotPart());
		this.add(new WorkerScoutPart(1600));
		this.add(new ExpandPart(true));
		this.add(new GenericPartFactory(UnitType.Terran_Barracks).create());
		ExpandPart.maximumCcs = 1;

		this.add(new GenericPartFactory(UnitType.Terran_Factory)
				.add(new UnitRequirement(UnitType.Terran_Barracks, 1, true))
				.add(new UnitRequirement(UnitType.Terran_Command_Center))
				.create());

		this.add(new GenericPartFactory(UnitType.Terran_Factory)
				.setMax(7)
				.add(new UnitRequirement(UnitType.Terran_Barracks, 1, true))
				.add(new LinearMax(UnitType.Terran_Command_Center, UnitType.Terran_Factory, 3, 0, false))
				.add(new UnitRequirement(UnitType.Terran_Siege_Tank_Tank_Mode))
				.create());

		this.add(new GenericPartFactory(UnitType.Terran_Academy)
			.add(new UnitRequirement(UnitType.Terran_Barracks, 1, true))
			.add(new UnitRequirement(UnitType.Terran_Refinery, 1, true))
			.add(new ArmyRequirement(10))
			.create());
		
		this.add(new GenericPartFactory(UnitType.Terran_Armory)
			.setMax(2)
			.add(new UnitRequirement(UnitType.Terran_Factory, 6))
			.add(new UnitRequirement(UnitType.Terran_Engineering_Bay))
			.create());
		
		this.add(new GenericPartFactory(UnitType.Terran_Starport)
			.add(new UnitRequirement(UnitType.Terran_Armory, 2))
			.add(new UnitRequirement(UnitType.Terran_Factory, 6))
			.create());
		
		this.add(new GenericPartFactory(UnitType.Terran_Science_Facility)
			.add(new UnitRequirement(UnitType.Terran_Armory, 2))
			.add(new UnitRequirement(UnitType.Terran_Starport, 1, true))
			.create());
		
		this.add(new GenericPartFactory(UnitType.Terran_Engineering_Bay)
			.add(new UnitRequirement(UnitType.Terran_Factory, 4))
			.create());
			
		super.initialize(game, self, bot);
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot)
	{
		DebugMessages.addMessage("Going mech.");
		
		StopWatch watch = new StopWatch();
		long time;
		watch.start();
		
		if (ExpandPart.maximumCcs < 100
				&& UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) >= 4
				&& UnitTracker.count(UnitType.Terran_Vulture) >= 4)
			ExpandPart.maximumCcs = 100;
		
		super.onFrame(game, self, bot);
		
		if (UnitTracker.count(UnitType.Terran_Factory)  < 1 && (bot.getAvailableGas() >= 100 || bot.getAvailableMinerals() < 100))
			Settings.setWorkersPerGas(1);
		else if (UnitTracker.count(UnitType.Terran_Factory)  <= 2)
			Settings.setWorkersPerGas(2);
		else
			Settings.setWorkersPerGas(3);
		
		time = watch.time();
		if (time > 55)
			DebugMessages.addMessage("Mech super time: " + time);
		
		if(UnitTracker.count(UnitType.Terran_Refinery) < UnitTracker.count(UnitType.Terran_Command_Center) 
				&& bot.getAvailableMinerals()>= 100 
				&& UnitTracker.getGeyserCount() > 0
				&& (UnitTracker.count(UnitType.Terran_Refinery) == 0 || UnitTracker.count(UnitType.Terran_Factory) >= 4)) 
		{
			bot.spaceManager.build(UnitType.Terran_Refinery);
		}
		
		time = watch.time();
		if (time > 55)
			DebugMessages.addMessage("Mech tier 1 time: " + time);
				time = watch.time();
		
		// Build bunkers.
		if (bot.getAvailableMinerals() >= 100 
				&& UnitTracker.count(UnitType.Terran_Factory) >= 1 
				&& UnitTracker.count(UnitType.Terran_Bunker) < 2)
		{
			for(DefensiveStructures structures : bot.defensiveStructures)
			{
				int count = structures.getUnitCount(UnitType.Terran_Bunker);
				
				if(count < 1)
				{
					bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
		  			break;
				}
			}
		}
		
		if (game.enemy().getRace() != Race.Protoss
				&& bot.getAvailableMinerals() >= 75 
				&& UnitTracker.count(UnitType.Terran_Barracks) >= 1 
				&& UnitTracker.count(UnitType.Terran_Missile_Turret) < 6
				&& self.completedUnitCount(UnitType.Terran_Engineering_Bay) >= 1)
			bot.spaceManager.build(UnitType.Terran_Missile_Turret);

		time = watch.time();
		if (time > 55)
			DebugMessages.addMessage("Mech bunker time: " + time);
	}

	@Override
	public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent)
	{
		if(super.overrideStructureOrder(game, self, bot, agent))
			return true;
		
		if(agent.unit.getType() == UnitType.Terran_Barracks)
		{
			if (UnitTracker.count(UnitType.Terran_Marine) >= UnitTracker.count(UnitType.Terran_Bunker)*4)
				return true;
		}
		
		if(agent.unit.getType() == UnitType.Terran_Starport)
			return true;
		
		if (agent.unit.getType() == UnitType.Terran_Factory)
		{
			if (agent.unit.getAddon() != null)
			{
				if (UnitTracker.count(UnitType.Terran_Factory) <= 1 
						&& UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) >= 2)
					return false;
				return !self.isResearching(TechType.Tank_Siege_Mode) && !self.hasResearched(TechType.Tank_Siege_Mode);
			}

			boolean addonWanted = UnitTracker.usableAddOns(UnitType.Terran_Machine_Shop)*3 + 1 < self.completedUnitCount(UnitType.Terran_Factory)
					|| self.completedUnitCount(UnitType.Terran_Factory) <= 1;
			
			if(self.completedUnitCount(UnitType.Terran_Armory) >= 1 && !agent.unit.isTraining()
					&& UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) 
						>= 5 + (UnitTracker.count(UnitType.Terran_Goliath)/(game.enemy().getRace() == Race.Protoss?1:2)) 
					&& bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 50)
			{
				agent.unit.train(UnitType.Terran_Goliath);
				return true;
			}
			else if (bot.getAvailableMinerals() >= 75 && !agent.unit.isTraining() && 
					UnitTracker.count(UnitType.Terran_Vulture) <= 2*(UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode)) + 1
					&& (UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) >= 2
						|| bot.getAvailableMinerals() >= 300))
			{
				agent.unit.train(UnitType.Terran_Vulture);
				return true;
			}
			
			return !addonWanted;
		}
		else if(agent.unit.getType() == UnitType.Terran_Armory)
		{
			if(bot.getAvailableMinerals() >= UpgradeType.Terran_Vehicle_Weapons.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Terran_Vehicle_Weapons.gasPrice())
				agent.unit.upgrade(UpgradeType.Terran_Vehicle_Weapons);
			
			if(bot.getAvailableMinerals() >= UpgradeType.Terran_Vehicle_Plating.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Terran_Vehicle_Plating.gasPrice())
				agent.unit.upgrade(UpgradeType.Terran_Vehicle_Plating);
			
			return true;
		}
		else if (agent.unit.getType() == UnitType.Terran_Engineering_Bay)
		{
			return true;
		}
		else if (agent.unit.getType() == UnitType.Terran_Machine_Shop)
		{
			if (!agent.unit.isResearching() 
					&& UnitTracker.count(UnitType.Terran_Armory) > 0
					&& bot.getAvailableMinerals() >= 100
					&& bot.getAvailableGas() >= 100)
				agent.unit.upgrade(UpgradeType.Charon_Boosters);
		}
		return false;
	}
}
