/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.buildingplacement;

import com.tyr.agents.Agent;



/**
 * This class registers the information about a command to repair a building.
 * @author Simon
 *
 */
public class RepairCommand 
{
	/**
	 * The worker who will place the building.
	 */
	public Agent worker;
	
	/**
	 * The building that has to be repaired.
	 */
	public Agent target;
	
	public RepairCommand(Agent worker, Agent target)
	{
		this.worker = worker;
		this.target = target;
	}
}
