/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.buildingplacement;

import com.tyr.Tyr;
import com.tyr.agents.Agent;

import bwapi.TilePosition;
import bwapi.UnitType;


/**
 * This is a class which allows you to find a location to place a building.
 * @author Simon
 *
 */
public abstract class BuildSiteLocator 
{
	/**
	 * Finds a building placement for the given building type.
	 * @param building The type of building for which we want to find a placement.
	 * @param preferredTile A location for which we want to find a nearby placement.
	 * @param worker The worker who has been selected to build the building.
	 * @return A tilePosition where the building can be built.
	 */
	public abstract TilePosition findPlacement(UnitType building, TilePosition preferredTile, Agent worker);
	
	/**
	 * Determines if this BuildSiteLocator can find a placement for the given building type.
	 * @param building The type of building for which we want to find a placement.
	 * @param preferredTile A location for which we want to find a nearby placement.
	 * @return Whether or not this BuildSiteLocator can find a placement for the given building type.
	 */
	public boolean hasPlacement(UnitType building, TilePosition preferredTile)
	{
		Agent worker = Tyr.bot.workForce.pop();
		boolean result = findPlacement(building, preferredTile, worker) != null;
		Tyr.bot.workForce.add(worker);
		return result;
	}
	
	/**
	 * Have we already reserved space for the building to be built?
	 * @return Have we already reserved space for the building to be built?
	 */
	public boolean alreadyReserved()
	{
		return false;
	}
}
