/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.agents;

import com.tyr.Tyr;

import bwapi.Game;
import bwapi.Player;


/**
 * An empty command that can be ordered when an agent should do nothing.
 * @author Simon
 *
 */
public class None extends Command
{
	/**
	 * An empty command that can be ordered when an agent should do nothing.
	 * @param agent The agent to which we give the order.
	 */
	public None(Agent agent)
	{
		super(agent);
	}
	
	@Override
	public void execute(Game game, Player self, Tyr bot) {}

	@Override
	public boolean replace(Command command) 
	{
		// We can replace any existing command.
		return true;
	}

}
