/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.unitgroups;

import com.tyr.BWTAProxy;
import com.tyr.Scanner;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.WraithAgent;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;


/**
 * Unit group which controls a group of wraiths flying around the map, harassing.
 * No longer used.
 * @author Simon
 *
 */
public class WraithSwarm extends UnitGroup 
{
	/**
	 * OutOfJob where units will be sent when they are no longer needed.
	 */
	public OutOfJob outOfJob = new OutOfJob();
	
	/**
	 * Total number of bases, excluding our own.
	 */
	int bases = 1;
	
	/**
	 * The number of the base to which we will send our next wraith.
	 */
	int nextBase = 0;
	
	/**
	 * Unit group which controls a group of wraiths flying around the map, harassing.
	 * No longer used.
	 * @param rejects OutOfJob where units will be sent when they are no longer needed.
	 */
	public WraithSwarm(OutOfJob rejects)
	{
		super(rejects);
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot)
	{
		if(BWTAProxy.initialized)
		{
			if (bot.scanner.action == Scanner.Eliminating)
			{
				// Allow the scanner to control the wraiths.
				for(Agent agent = pop(); agent != null; agent = pop())
					bot.scanner.addAir(agent);
			}
			for(Agent unit : units)
			{
				unit.drawCircle(Color.Cyan);
				
				// Let the agent perform the actual work.
				WraithAgent agent = (WraithAgent)unit;
				agent.onFrame(game, self, bot);
			}
		}
	}
	
	@Override
	public void add(Agent unit)
	{
		// We cycle through all known bases and assign the wraith to one of them for its first attack.
		if (bases <= 1)
			bases = Math.max(1, Tyr.bot.suspectedEnemy.size() + Tyr.bot.expands.size());
		
		nextBase--;
		super.add(unit);
		((WraithAgent)unit).current = nextBase;
		outOfJob.add(unit);
		
		if (nextBase < 0)
			nextBase += bases;
	}
	
	@Override
	public int takeAgent(Agent agent)
	{
		if(agent.unit.getType() == UnitType.Terran_Wraith)
			return 10;
		else
			return -1;
	}
}
