/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import com.tyr.BWTAProxy;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;


/**
 * A task for sieging up at the opponents natural using siege tanks.
 */
public class SiegeNaturalTask extends Task
{
	/**
	 * The target position where we want the army to attack.
	 */
	private Position target;
	
	public int requiredTanks = 6;
	
	public int requiredReinforcements = 2;
	
	public static boolean done; 
	
	/**
	 * A task for sieging up at the opponents natural using siege tanks.
	 */
	public SiegeNaturalTask()
	{}
	
	@Override
	public boolean isRequired(Game game, Player self, Tyr bot) 
	{
		if (done)
			return false;
		
		if (bot.suspectedEnemy.size() != 1)
			return false;
		
		return true;
	}
	
	@Override
	public void solve(Game game, Player self, Tyr bot)
	{
		// If we find a new target to attack, we set that new target.
		if (!BWTAProxy.initialized)
			return;
		boolean newTarget = acquireTarget(bot); 
		if(newTarget)
			((SiegeNaturalSolution)solution).setTarget(target);

		
		int tankCount = 0;
		for (Agent agent : bot.homeGroup.units)
			if (agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode || agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode )
				tankCount++;
		
		if (tankCount >= requiredReinforcements
				&& UnitTracker.countTanks() >= requiredTanks)
		{
			for(int i = bot.homeGroup.units.size() - 1; i >= 0; i--)
			{
				Agent agent = bot.homeGroup.units.get(i);
				((SiegeNaturalSolution)solution).add(agent);
				bot.homeGroup.units.remove(i);
			}
		}
		
		// We call the super class, which will send the units out to attack.
		super.solve(game, self, bot);
		
		if (((SiegeNaturalSolution)solution).done() && !done)
		{
			((SiegeNaturalSolution)solution).done(bot.homeGroup);
			solution = null;
			done = true;
		}
	}

	@Override
	public void findSolution(Game game, Player self, Tyr bot)
	{
		if (BWTAProxy.initialized)
			acquireTarget(bot);
		solution = new SiegeNaturalSolution(this, target);
	}
	
	/**
	 * See if we need to find a new target to attack.
	 * If so we return true, if the current target is already fine, we return false.
	 */
	public boolean acquireTarget(Tyr bot)
	{
		if (target == null)
		{
			target = bot.suspectedEnemy.get(0).getPosition();
			return true;
		}
		return false;
	}
}
