/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;


/**
 * A task for attacking the enemy player by going by every expand.
 */
public class SalesmenMarinesTask extends Task
{
	public static boolean paused = false;

	/**
	 * The direction in which we will send the next attack.
	 */
	private int direction = 1;
	
	/**
	 * The only type of unit we will send.
	 * If this remains null, we will send any type of unit.
	 */
	private UnitType onlyType = null;
	
	/**
	 * How many units do we need before we send out the attack?
	 */
	private int requiredSize = 15;
	
	/**
	 * What is the maximum number of medics we will send?
	 */
	private int maxMedics = 4;
	
	/**
	 * Do we attack in the direction of the opponents main the first time?
	 */
	private boolean attackDirect = false;
	
	/**
	 * The number of units needed for the defense.
	 */
	private int requiredDefense;
	
	/**
	 * A task for attacking the enemy player by going by every expand.
	 */
	public SalesmenMarinesTask() { }
	
	/**
	 * A task for attacking the enemy player by going by every expand.
	 * @param onlyType The only type of unit we will send.
	 *        If this remains null, we will send any type of unit.
	 */
	public SalesmenMarinesTask(UnitType onlyType)
	{
		this.onlyType = onlyType;
	}
	
	/**
	 * A task for attacking the enemy player by going by every expand.
	 * @param onlyType The only type of unit we will send.
	 *        If this remains null, we will send any type of unit.
	 * @param requiredSize How many units do we need before we send out the attack?
	 * @param maxMedics What is the maximum number of medics we will send?
	 * @param attackDirect Do we attack in the direction of the opponents main the first time?
	 * @param requiredDefense The number of units needed for the defense.
	 */
	public SalesmenMarinesTask(UnitType onlyType, int requiredSize, int maxMedics, boolean attackDirect, int requiredDefense)
	{
		this.onlyType = onlyType;
		this.requiredSize = requiredSize;
		this.maxMedics = maxMedics;
		this.attackDirect = attackDirect;
		this.requiredDefense = requiredDefense;
	}
	
	@Override
	public boolean isRequired(Game game, Player self, Tyr bot) 
	{
		if (solution != null)
		{
			if (((SolutionList)solution).size() == 0)
				solution = null;
			else return true;
		}
		
		if (solution == null && Settings.getBlockAttack())
			return false;
        
		return bot.homeGroup.units.size() >= requiredSize + requiredDefense
				&& bot.homeGroup.units.size() - UnitTracker.count(UnitType.Terran_Medic) + maxMedics >= requiredSize;
	
	}
	
	@Override
	public void solve(Game game, Player self, Tyr bot)
	{
		if (attackDirect)
		{
			attackDirect = false;
			if (EnemyManager.getManager().getOrderedExpands() != null
					&& EnemyManager.getManager().getSelfPos() * 2 >= EnemyManager.getManager().getOrderedExpands().size())
				direction = 1;
			else direction = -1;
		}
		
		boolean sendOut = bot.homeGroup.units.size() >= requiredSize + requiredDefense;
		int marineCount = 0;
		if (sendOut)
			for (Agent agent : bot.homeGroup.units)
				if ((onlyType == null || agent.unit.getType() == onlyType) && agent.unit.getType() != UnitType.Terran_Medic)
					marineCount++;
		sendOut = marineCount >= requiredSize - maxMedics;
		
		if (sendOut && !paused)
		{
			SalesmenMarinesSolution sol = new SalesmenMarinesSolution(this, direction);
			direction *=-1;
			int medics = 0;
			for(int i = bot.homeGroup.units.size()-1; i >= 0 && sol.size() < requiredSize; i--)
			{
				Agent agent = bot.homeGroup.units.get(i);
				if ((agent.unit.getType() != UnitType.Terran_Medic && (onlyType == null ||agent.unit.getType() == onlyType)) 
						|| (agent.unit.getType() == UnitType.Terran_Medic && medics < maxMedics))
				{
					sol.add(agent);
					bot.homeGroup.units.remove(i);
					if (agent.unit.getType() == UnitType.Terran_Medic)
						medics++;
				}
			}
			((SolutionList)solution).add(sol);
		}
		
		// We call the super class, which will send the units out to attack.
		super.solve(game, self, bot);
	}

	@Override
	public void findSolution(Game game, Player self, Tyr bot)
	{
		solution = new SolutionList(this);
	}
}
