/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import java.util.List;

import com.tyr.DebugMessages;
import com.tyr.Tyr;
import com.tyr.agents.Agent;

import bwapi.Game;
import bwapi.Player;


/**
 * A task that performs a runby.
 */
public class RunbyTask extends Task
{
	private static RunbyTask task;
	
	public static boolean completed = false;
	
	private RunbyTask()
	{
		super();
		task = this;
	}
	
	public static RunbyTask getTask()
	{
		if (task == null)
			task = new RunbyTask();
		return task;
	}
	
	public static boolean isCreated()
	{
		return task != null && !completed;
	}
	
	@Override
	public boolean isRequired(Game game, Player self, Tyr bot) 
	{
		return true;
	}
	
	@Override
	public void solve(Game game, Player self, Tyr bot)
	{
		if (solution == null)
			DebugMessages.addMessage("SolutionList is null.");
		else
			DebugMessages.addMessage("SolutionList size: " + ((SolutionList)solution).size());
		// We call the super class, which will send the units out to attack.
		super.solve(game, self, bot);
	}

	@Override
	public void findSolution(Game game, Player self, Tyr bot)
	{
		if (solution == null)
		{
			solution = new SolutionList(this);
			System.out.println("Creating new solution list.");
		}
	}
	
	public void addRunby(List<Agent> agents)
	{
		if (solution == null)
		{
			solution = new SolutionList(this);
			System.out.println("Creating new solution list.");
		}
		((SolutionList)solution).add(new RunbySolution(this, agents));
		System.out.println("Adding runby solution. " + ((SolutionList)solution).size());
	}
}
