/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;


/**
 * A task to send a science vessel to our natural.
 */
public class ExploreScienceTask extends Task
{
	@Override
	public boolean isRequired(Game game, Player self, Tyr bot) 
	{
		return UnitTracker.count(UnitType.Terran_Science_Vessel) > 0;
	}

	@Override
	public void solve(Game game, Player self, Tyr bot)
	{
		ExploreScienceSolution exploreSolution = (ExploreScienceSolution)solution;
		// Get the units required for this task.
		for (int i=bot.homeGroup.units.size() - 1; i >= 0; i--)
		{
			if (exploreSolution.hasVessel() && exploreSolution.tankCount() >= 4)
				break;
			Agent agent = bot.homeGroup.units.get(i);
			
			if (agent.unit.getType() == UnitType.Terran_Science_Vessel && !exploreSolution.hasVessel())
			{
				exploreSolution.setVessel(agent);
				bot.homeGroup.units.remove(i);
			} else if (exploreSolution.hasVessel() && agent.isTank() && exploreSolution.tankCount() < 4)
			{
				exploreSolution.addTank(agent);
				bot.homeGroup.units.remove(i);
			}
		}
		
		// We call the super class, which will call the solutions onFrame method.
		super.solve(game, self, bot);
	}

	@Override
	public void findSolution(Game game, Player self, Tyr bot)
	{
		solution = new ExploreScienceSolution(this);
	}
}
