/*
 * Tyr is an AI for StarCraft: Broodwar, 
 * 
 * Please visit https://github.com/SimonPrins/Tyr for further information.
 * 
 * Copyright 2015 Simon Prins
 *
 * This file is part of Tyr.
 * Tyr is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * Tyr is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with Tyr.  If not, see http://www.gnu.org/licenses/.
 */


package com.tyr.tasks;

import java.util.ArrayList;

import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.SpaceManager;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;

/**
 * Push to secure our natural expand.
 */
public class ExpandPushTask extends Task
{
	@Override
	public boolean isRequired(Game game, Player self, Tyr bot) 
	{
		if (bot.defensiveStructures.size() >= 2)
		{
			if (solution != null)
			{
				((ExpandPushSolution)solution).clear();
				solution = null;
			}
			return false;
		}
		
		return true;
	}

	@Override
	public void solve(Game game, Player self, Tyr bot)
	{
		if (game.getFrameCount() % 10 == 0)
		{
			ArrayList<Position> orderedExpands = EnemyManager.getManager().getOrderedExpands();
			
			Position target = null;
			
			if (orderedExpands == null)
				return;
			
			Position exit = SpaceManager.getMainExit();
			int down = (EnemyManager.getManager().getSelfPos() - 1 + orderedExpands.size())%orderedExpands.size();
			int up = (EnemyManager.getManager().getSelfPos() + 1)%orderedExpands.size();
			
			if (orderedExpands.get(down).getDistance(exit) < orderedExpands.get(up).getDistance(exit))
				target = determineTarget(orderedExpands.get(down));
			else
				target = determineTarget(orderedExpands.get(up));
				((ExpandPushSolution) solution).setTarget(target);
		}
		// Get the vultures needed for the push.
		for (int i = bot.homeGroup.units.size() - 1; i >= 0; i--)
		{
			Agent agent = bot.homeGroup.units.get(i);

			((ExpandPushSolution) solution).add(agent);
			bot.homeGroup.units.remove(i);
		}
		
		// We call the super class, which will send out the push.
		super.solve(game, self, bot);
	}

	private Position determineTarget(Position base)
	{
		return SpaceManager.getDefensePos(base);
		//return new Position(halfWay.getX()*2-base.getX(), halfWay.getY()*2-base.getY());
	}

	@Override
	public void findSolution(Game game, Player self, Tyr bot)
	{
		ArrayList<Position> orderedExpands = EnemyManager.getManager().getOrderedExpands();
		
		Position target = null;
		
		if (orderedExpands == null)
			return;
		
		Position exit = SpaceManager.getMainExit();
		int down = (EnemyManager.getManager().getSelfPos() - 1 + orderedExpands.size())%orderedExpands.size();
		int up = (EnemyManager.getManager().getSelfPos() + 1)%orderedExpands.size();
		
		if (orderedExpands.get(down).getDistance(exit) < orderedExpands.get(up).getDistance(exit))
			target = determineTarget(orderedExpands.get(down));
		else
			target = determineTarget(orderedExpands.get(up));

		
		solution = new ExpandPushSolution(this, target);

		// Get the vultures needed for the harass.
		for (int i = bot.homeGroup.units.size() - 1; i >= 0; i--)
		{
			Agent agent = bot.homeGroup.units.get(i);

			((ExpandPushSolution) solution).add(agent);
			bot.homeGroup.units.remove(i);
		}
	}
}
