/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import com.tyr.BWTAProxy;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;


/**
 * A task that constantly pushes the opponent.
 */
public class ClearExpandsTask extends Task
{
	private boolean active = false;
	private boolean useDTs = false;
	public static boolean allowFullAssault = true;
	
	public ClearExpandsTask() { }
	
	public ClearExpandsTask(boolean useDTs)
	{
		this.useDTs = useDTs;
	}

	@Override
	public boolean isRequired(Game game, Player self, Tyr bot) 
	{
		return Settings.getClearMinerals();
	}
	
	@Override
	public void solve(Game game, Player self, Tyr bot)
	{
		// If we find a new target to attack, we set that new target.
		if (!BWTAProxy.initialized)
			return;
		
		
		final boolean fullAssault = allowFullAssault && active && ((ClearExpandsSolution)solution).fullAssault();
		if (!fullAssault)
			((ClearExpandsSolution)solution).clear(bot.homeGroup.units);

		for(int i = bot.homeGroup.units.size() - 1; size() < 8 && active && i >= 0 && (this.size() == 0 || fullAssault); i--)
		{
			final Agent agent = bot.homeGroup.units.get(i);
			
			final UnitType firstType = useDTs ? UnitType.Protoss_Dark_Templar : UnitType.Protoss_Zealot;
			// First unit must be a zealot, or a DT if they are used.
			if (((ClearExpandsSolution)solution).size() == 0 && agent.unit.getType() != firstType)
				continue;
			
			((ClearExpandsSolution)solution).add(agent);
			bot.homeGroup.units.remove(i);
		}
		
		// We call the super class, which will send the units out to attack.
		super.solve(game, self, bot);
	}

	@Override
	public void findSolution(Game game, Player self, Tyr bot)
	{
		solution = new ClearExpandsSolution(this);
	}

	public int size()
	{
		return ((ClearExpandsSolution)solution).size();
	}
	
	public void setActive(boolean active)
	{
		this.active = active;
	}
	
	public boolean isActive()
	{
		return active;
	}
}
