/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;


/**
 * A task that manages all Battlecruisers.
 * It only starts a solution after the first Battlecruiser has been built.
 */
public class BCTask extends Task
{
	/**
	 * Has a Battlecruiser previously been built?
	 */
	boolean previousBCs = false;
	
	@Override
	public boolean isRequired(Game game, Player self, Tyr bot) 
	{
		// This task is required if we have built a Battlecruiser previously.
		if(previousBCs)
			return true;
		
		// We need to check if a Battlecruiser has been built since last frame.
		if (UnitTracker.count(UnitType.Terran_Battlecruiser) > 0)
			previousBCs = true;
		
		return previousBCs;
	}
	
	@Override
	public void solve(Game game, Player self, Tyr bot)
	{
		// Get all available Battlecruisers.
		for (int i=bot.homeGroup.units.size()-1; i >= 0; i--)
		{
			Agent agent = bot.homeGroup.units.get(i);
			if(agent.unit.getType() == UnitType.Terran_Battlecruiser)
			{
				((BCSolution)solution).add(agent);
				bot.homeGroup.units.remove(i);
			}
		}
		
		super.solve(game, self, bot);
	}

	@Override
	public void findSolution(Game game, Player self, Tyr bot)
	{
		if (previousBCs)
			solution = new BCSolution(this);
	}

}
