/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.requirements;

import com.tyr.Force;
import com.tyr.ForceTracker;
import com.tyr.Tyr;

/**
 * Do we have a certain army size?
 * @author Simon
 *
 */
public class ArmyRequirement implements Requirement 
{
	/**
	 * The number of units that need to be in the army.
	 */
	private int count;
	
	/**
	 * Do we have a certain army size?
	 * @param count The number of units that need to be in the army.
	 */
	public ArmyRequirement(int count)
	{
		this.count = count;
	}
	
	@Override
	public boolean met()
	{
		int number = Tyr.bot.homeGroup.units.size();
		for (Force f : ForceTracker.forces)
			number += f.size();
		return number >= count;
	}
}
