/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.tasks.AssignScience;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.UnitType;


public class OneBaseTank extends CompositeBuildOrder
{
	/**
	 * Have we reserved minerals and gas to build a science vessel?
	 */
	private boolean reserveScience;
	
	/**
	 * Do we commit fully to tanks?
	 */
	private boolean fullTank = true;
	
	public OneBaseTank() {}
	
	public OneBaseTank(boolean fullTank)
	{
		this.fullTank = fullTank;
	}
	
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		Settings.setWorkersPerGas(3);
		Settings.setMaximumWorkers(25);
		Settings.setRequiredSize(20);
		Settings.setMaximumSize(30);
		
		this.add(new SupplyDepotPart());
		this.add(new WorkerScoutPart(1600));
		//this.add(new ExpandPart(true));
		
		//ExpandPart.maximumCcs = 2;
		
		bot.taskManager.potentialTasks.add(new AssignScience());
	}
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot) 
	{
		super.onFrame(game, self, bot);
		
		Tyr.drawCircle(new Position(self.getStartLocation().getX()*32 + 64, self.getStartLocation().getY()*32 + 32), Color.Yellow, 64);
		
		//if we've the resources to build a barracks ...
		if(bot.getAvailableMinerals() >= 100 
				&& UnitTracker.count(UnitType.Terran_Barracks) == 0
				&& UnitTracker.count(UnitType.Terran_Refinery) >= 1)
		{
			bot.spaceManager.build(UnitType.Terran_Barracks);
		}
		
		if(bot.getAvailableMinerals() >= 150
				&& bot.getAvailableGas() >= 100
				&& (UnitTracker.count(UnitType.Terran_Factory) < 1 || (bot.getAvailableMinerals() >= 250 && bot.getAvailableGas() >= 150))
				&& UnitTracker.count(UnitType.Terran_Barracks) >= 1 
				&& (UnitTracker.count(UnitType.Terran_Factory) < 2 || UnitTracker.count(UnitType.Terran_Academy) > 0)
				&& UnitTracker.count(UnitType.Terran_Factory) < 3
			)
		{
			bot.spaceManager.build(UnitType.Terran_Factory);
		}
		
		if(UnitTracker.getGeyserCount() > 0 
				&& bot.getAvailableMinerals() >= 100 
				&& UnitTracker.count(UnitType.Terran_Refinery) == 0
				&& UnitTracker.count(UnitType.Terran_Supply_Depot) > 0) 
		{
			bot.spaceManager.build(UnitType.Terran_Refinery);
		}
		
		if (UnitTracker.countTanks() >= 4
				&& bot.getAvailableMinerals() >= 150
				&& UnitTracker.count(UnitType.Terran_Academy) == 0)
		{
			bot.spaceManager.build(UnitType.Terran_Academy);
		}
		
		if (self.completedUnitCount(UnitType.Terran_Factory) >= 3
				&& UnitTracker.count(UnitType.Terran_Starport) == 0
				&& bot.getAvailableGas() >= 100
				&& bot.getAvailableMinerals() >= 150)
		{
			bot.spaceManager.build(UnitType.Terran_Starport);
		}
		
		if (UnitTracker.count(UnitType.Terran_Science_Facility) < 1
				&& self.completedUnitCount(UnitType.Terran_Starport) > 0
				&& bot.getAvailableGas() >= 150
				&& bot.getAvailableMinerals() >= 100)
		{
			bot.spaceManager.build(UnitType.Terran_Science_Facility);
		}

		// Build bunkers.
		if (bot.getAvailableMinerals() >= 50 
				&& (bot.getAvailableMinerals() >= 100 ||  UnitTracker.count(UnitType.Terran_Factory) > 1)
				&& (UnitTracker.count(UnitType.Terran_Factory) >= 1) 
				&& self.completedUnitCount(UnitType.Terran_Barracks) >= 1
				&& UnitTracker.count(UnitType.Terran_Bunker) < 2)
		{
			for(DefensiveStructures structures : bot.defensiveStructures)
			{
				int count = structures.getUnitCount(UnitType.Terran_Bunker);
				
				if(count < 1)
				{
					// We do not build a bunker at our main if there already is one at our natural.
					if (bot.defensiveStructures.size() > 1 && structures.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) <= 200)
					{
						if (UnitTracker.count(UnitType.Terran_Bunker) == 0)
							continue;
						else
							break;
					}
					
					bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
		  			break;
				}
			}
		}
	}
	
	@Override
	public boolean overrideStructureOrder(Game game, Player self, Tyr bot,
			Agent agent)
	{
		if (agent.unit.getType() == UnitType.Terran_Barracks)
		{
			return bot.getAvailableMinerals() < 350 && !fullTank;
		}
		if (agent.unit.getType() == UnitType.Terran_Factory)
		{
			if (agent.unit.getAddon() != null)
				return false;
			
			if (UnitTracker.count(UnitType.Terran_Machine_Shop) == 0)
				return false;
			
			if (fullTank && UnitTracker.count(UnitType.Terran_Machine_Shop) < 2)
				return false;
				
			if (Tyr.bot.getAvailableMinerals() >= 75
					&& !agent.unit.isTraining())
				agent.unit.train(UnitType.Terran_Vulture);
			
			return true;
		}
		
		if(agent.unit.getType() == UnitType.Terran_Starport)
		{
			if (agent.unit.isTraining())
				return true;
			
			if (Tyr.game.enemy().getRace() != Race.Protoss)
				return true;
			
			if (agent.unit.getAddon() == null
					&& bot.getAvailableGas() >= 50
					&& bot.getAvailableMinerals() >= 50
					&& UnitTracker.count(UnitType.Terran_Science_Facility) > 0)
				agent.unit.buildAddon(UnitType.Terran_Control_Tower);
			else if (UnitTracker.count(UnitType.Terran_Science_Vessel) < 2
					&& self.completedUnitCount(UnitType.Terran_Science_Facility) > 0)
			{
				if (bot.getAvailableMinerals() >= 100
						&& bot.getAvailableGas() >= 225
						&& !reserveScience)
					agent.unit.train(UnitType.Terran_Science_Vessel);
				else if (!reserveScience)
				{
					reserveScience = true;
					bot.reservedMinerals += 100;
					bot.reservedGas += 225;
				}
				else if (reserveScience
						&& self.minerals() >= 100
						&& self.gas() >= 225)
				{
					agent.unit.train(UnitType.Terran_Science_Vessel);
					reserveScience = false;
					bot.reservedMinerals -= 100;
					bot.reservedGas -= 225;
				}
			}
			return true;
		}
		return false;
	}

}
