/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.tasks.ConstantPushTask;
import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;
import bwapi.UpgradeType;


public class MassReaver extends CompositeBuildOrder
{
	boolean defensesInitialized = false;
	boolean sendDragoons = false;
	boolean sendReavers = false;
	
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		Settings.setRequiredSize(100);
		Settings.setMaximumSize(100);
		Settings.setMaximumWorkers(40);
		Settings.setSmallInvasionDist(480);
		Settings.setLargeInvasionDist(768);
		Settings.setWorkersPerGas(3);
		Attack.dontWaitAtCannon = true;
		
		this.add(new ExpandPart(true));
		this.add(new WorkerScoutPart(1600));
		
		super.initialize(game, self, bot);
	}

	@Override
	public void onFrame(Game game, Player self, Tyr bot) 
	{
		super.onFrame(game, self, bot);
		
		ExpandPart.maximumCcs = count(REAVER) > 0 ? 2 : 1;
		
		if (!sendDragoons && self.completedUnitCount(UnitType.Protoss_Dragoon) >= 10)
		{
			sendDragoons = true;
			bot.taskManager.potentialTasks.add(new ConstantPushTask());
		}
		
		//if we're running out of supply and have enough minerals ...
		if ((self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() 
					<= UnitTracker.count(UnitType.Protoss_Gateway)*3 + UnitTracker.getCcCount() * 3)
				&& (bot.getAvailableMinerals() >= 100)
				&& self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400)
		{
			bot.spaceManager.build(UnitType.Protoss_Pylon);
		}
		
		//if we've the resources to build a Gateway ...
		if (bot.getAvailableMinerals() >= 150
				&& UnitTracker.count(UnitType.Protoss_Gateway) == 0
				&& self.completedUnitCount(UnitType.Protoss_Pylon) > 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Gateway);
		}
		
		if (bot.getAvailableMinerals() >= 150
				&& UnitTracker.count(UnitType.Protoss_Gateway) < 4
				&& UnitTracker.count(UnitType.Protoss_Gateway) > 0
				&& UnitTracker.count(NEXUS) > 1
				&& count(REAVER) >= 3)
		{
			bot.spaceManager.build(UnitType.Protoss_Gateway);
		}
		
		if(UnitTracker.count(UnitType.Protoss_Assimilator) < 2
				&& bot.getAvailableMinerals() >= 100 
				&& UnitTracker.getGeyserCount() > 0
				&& UnitTracker.count(UnitType.Protoss_Gateway) > 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Assimilator);
		}
		
		if (bot.getAvailableMinerals()>= 200 
				&& UnitTracker.count(UnitType.Protoss_Cybernetics_Core) < 1
				&& self.completedUnitCount(UnitType.Protoss_Gateway) > 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Cybernetics_Core);
		}
		
		if (bot.getAvailableGas() >= 200 && bot.getAvailableMinerals() >= 200
				&& completed(UnitType.Protoss_Cybernetics_Core) > 0
				&& UnitTracker.count(UnitType.Protoss_Robotics_Facility) == 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Robotics_Facility);
		}

		if (bot.getAvailableGas() >= 200 && bot.getAvailableMinerals() >= 200
				&& completed(UnitType.Protoss_Cybernetics_Core) > 0
				&& UnitTracker.count(UnitType.Protoss_Robotics_Facility) == 1
				&& count(ROBO_SUPPORT) > 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Robotics_Facility);
		}
		
		if (bot.getAvailableGas() >= 100 && bot.getAvailableMinerals() >= 150
				&& self.completedUnitCount(UnitType.Protoss_Robotics_Facility) > 0
				&& UnitTracker.count(UnitType.Protoss_Robotics_Support_Bay) == 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Robotics_Support_Bay);
		}
	}
	
	@Override
	public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent)
	{
		if (agent.unit.getType() == UnitType.Protoss_Gateway && !agent.unit.isTraining())
		{
			if (count(ZEALOT) < 3 && minerals() >= 100)
				agent.unit.build(ZEALOT);
			if (UnitTracker.count(UnitType.Protoss_Reaver) < 2 && (minerals() <= 300 || gas() <= 200) )
				return true;
			if (UnitTracker.count(UnitType.Protoss_Reaver) >= 3 && minerals() >= 125 && gas() >= 50)
				agent.unit.build(UnitType.Protoss_Dragoon);
			else if (bot.getAvailableMinerals() >= 250 && bot.getAvailableGas() >= 50)
				agent.unit.build(UnitType.Protoss_Dragoon);
			return true;
		}
		else if (agent.unit.getType() == UnitType.Protoss_Forge && !agent.unit.isUpgrading())
		{
			if(bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice())
				agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
			
			if(bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Armor.gasPrice())
				agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
		}
		else if (agent.unit.getType() == UnitType.Protoss_Cybernetics_Core && !agent.unit.isUpgrading())
		{
			if(bot.getAvailableMinerals() >= UpgradeType.Singularity_Charge.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Singularity_Charge.gasPrice()
					&& UnitTracker.count(UnitType.Protoss_Reaver) >= 2)
				agent.unit.upgrade(UpgradeType.Singularity_Charge);
		}
		else if (agent.unit.getType() == UnitType.Protoss_Robotics_Facility)
		{
			if (!agent.unit.isTraining()
					&& bot.getAvailableMinerals() >= 200
					&& bot.getAvailableGas() >= 100
					&& count(REAVER) < 4)
				agent.unit.build(UnitType.Protoss_Reaver);
			return true;
		}
		return false;
	}
}
