/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.tasks.BuildAtLocationTask;
import com.tyr.tasks.ConstantPushTask;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;
import bwapi.UpgradeType;


public class FiveGate extends CompositeBuildOrder
{
	boolean attackStarted = false;
	
	private ConstantPushTask constantPushTask;
	
	private boolean detectionNeeded = false;;
	
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		Settings.setRequiredSize(100);
		Settings.setMaximumSize(100);
		Settings.setMaximumWorkers(40);
		Attack.dontWaitAtCannon = true;
		
		this.add(new ExpandPart(true));
		ExpandPart.maximumCcs = 2;
		this.add(new WorkerScoutPart(1600));
		
		super.initialize(game, self, bot);
	}

	@Override
	public void onFrame(Game game, Player self, Tyr bot) 
	{
		super.onFrame(game, self, bot);
		
		if (UnitTracker.count(UnitType.Protoss_Gateway) >= 3)
			Settings.setWorkersPerGas(3);
			
		if (EnemyManager.getManager().getEnemyTypes().contains(UnitType.Protoss_Dark_Templar) ||EnemyManager.getManager().getEnemyTypes().contains(UnitType.Zerg_Lurker))
			detectionNeeded = true;
		
		if (!attackStarted && bot.homeGroup.units.size() >= 20)
		{
			attackStarted = true;
			
			constantPushTask = new ConstantPushTask(null);
			bot.taskManager.potentialTasks.add(constantPushTask);
			ExpandPart.maximumCcs = 100;
			BuildAtLocationTask.stop = true;
		}
		
		if (attackStarted)
			DebugMessages.addMessage("Attacking!");
			
		if (constantPushTask != null && self.completedUnitCount(UnitType.Protoss_Zealot) + self.completedUnitCount(UnitType.Protoss_Dragoon) <= 10)
			constantPushTask.stop = true;
		if (constantPushTask != null && self.completedUnitCount(UnitType.Protoss_Zealot) + self.completedUnitCount(UnitType.Protoss_Dragoon) >= 20)
			constantPushTask.stop = false;
		
		//if we're running out of supply and have enough minerals ...
		if ((self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() 
					<= UnitTracker.count(UnitType.Protoss_Gateway)*3 + UnitTracker.getCcCount() * 3)
				&& (bot.getAvailableMinerals() >= 100)
				&& self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400
				&& UnitTracker.count(UnitType.Protoss_Nexus) >= 2)
		{
			bot.spaceManager.build(UnitType.Protoss_Pylon);
		}
		
		//if we've the resources to build a Gateway ...
		if (bot.getAvailableMinerals() >= 150
				&& UnitTracker.count(UnitType.Protoss_Gateway) < 2
				&& UnitTracker.count(UnitType.Protoss_Nexus) >= 2)
		{
			bot.spaceManager.build(UnitType.Protoss_Gateway);
		}
		
		if (bot.getAvailableMinerals() >= 250
				&& UnitTracker.count(UnitType.Protoss_Gateway) < 5
				&& UnitTracker.count(UnitType.Protoss_Nexus) >= 2)
		{
			bot.spaceManager.build(UnitType.Protoss_Gateway);
		}
		
		if (UnitTracker.count(UnitType.Protoss_Nexus) >= 2
				&& bot.getAvailableMinerals() >= 500
				&& UnitTracker.count(UnitType.Protoss_Gateway) < 7)
		{
			bot.spaceManager.build(UnitType.Protoss_Gateway);
		}
		
		if(UnitTracker.count(UnitType.Protoss_Assimilator) < 2
				&& bot.getAvailableMinerals() >= 100 
				&& UnitTracker.getGeyserCount() > 0
				&& UnitTracker.count(UnitType.Protoss_Gateway) > 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Assimilator);
		}
		
		if (bot.getAvailableMinerals()>= 200 
				&& UnitTracker.count(UnitType.Protoss_Cybernetics_Core) < 1
				&& self.completedUnitCount(UnitType.Protoss_Gateway) > 0)
		{
			bot.spaceManager.build(UnitType.Protoss_Cybernetics_Core);
		}
	}
	
	@Override
	public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent)
	{
		if (agent.unit.getType() == UnitType.Protoss_Gateway && !agent.unit.isTraining())
		{
			if (detectionNeeded && UnitTracker.count(UnitType.Protoss_Observer) == 0 
				&& (bot.getAvailableMinerals() <= 325 || bot.getAvailableGas() <= 150))
				return true;
			if ((UnitTracker.count(UnitType.Protoss_Zealot) <= UnitTracker.count(UnitType.Protoss_Dragoon) || self.completedUnitCount(UnitType.Protoss_Cybernetics_Core) == 0)
					&& bot.getAvailableMinerals() >= 100)
				agent.unit.build(UnitType.Protoss_Zealot);
			else if (UnitTracker.count(UnitType.Protoss_Zealot) > UnitTracker.count(UnitType.Protoss_Dragoon)
					&& bot.getAvailableMinerals() >= 125 && bot.getAvailableGas() >= 50)
				agent.unit.build(UnitType.Protoss_Dragoon);
			return true;
		}
		else if (agent.unit.getType() == UnitType.Protoss_Forge && !agent.unit.isUpgrading())
		{
			if(bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice())
				agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
			
			if(bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Armor.gasPrice())
				agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
		}
		else if (agent.unit.getType() == UnitType.Protoss_Cybernetics_Core && !agent.unit.isUpgrading())
		{
			if(bot.getAvailableMinerals() >= UpgradeType.Singularity_Charge.mineralPrice()
					&& bot.getAvailableGas() >= UpgradeType.Singularity_Charge.gasPrice())
				agent.unit.upgrade(UpgradeType.Singularity_Charge);
		}
		else if (agent.unit.getType() == UnitType.Protoss_Robotics_Facility)
		{
			if ((UnitTracker.count(UnitType.Protoss_Observer) <= 2)
					&& bot.getAvailableMinerals() >= 25
					&& bot.getAvailableGas() >= 75
					&& !agent.unit.isTraining())
				agent.unit.build(UnitType.Protoss_Observer);
		}
		return false;
	}
}
