/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.agents;

import com.tyr.Tyr;

import bwapi.Game;
import bwapi.Player;


/**
 * The base command class.
 * Commands are used to order agents to performs certain tasks.
 * @author Simon
 *
 */
public abstract class Command
{
	/**
	 * The agent to which this command has been ordered.
	 */
	protected Agent agent;
	
	/**
	 *The base command class.
	 * Commands are used to order agents to performs certain tasks.
	 *  @param agent The agent to which this command has been ordered.
	 */
	public Command(Agent agent)
	{
		this.agent = agent;
	}
	
	/**
	 * Perform this command.
	 * This method is assumed to be called once per frame.
	 * @param game The game.
	 * @param self The player controlled by our bot.
	 * @param bot The instance of Tyr that is currently playing the game.
	 */
	public abstract void execute(Game game, Player self, Tyr bot);
	
	/**
	 * Determine whether this command should replace the existing command.
	 * @param command The existing command.
	 * @return True if the existing command should be replaced, false otherwise.
	 */
	public abstract boolean replace(Command command);
}
