/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr;

import java.util.Date;


/**
 * This class helps track execution times.
 * @author Simon
 *
 */
public class StopWatch 
{
	/**
	 * The time at which we started.
	 */
	private long lStartTime = 0;
	
	/**
	 * Let the stopwatch start recording.
	 */
	public void start()
	{
		lStartTime = new Date().getTime();
	}
	
	/**
	 * Returns the time for which the stopwatch ran and resets the timer.
	 * @return The time in milliseconds since the last call of either start or time.
	 */
	public long time()
	{
		final long lEndTime = new Date().getTime();
		final long difference = lEndTime - lStartTime;
 
		// Reset the timer.
		lStartTime = lEndTime;
		
		return difference;
	}
}
