/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr;

import java.util.ArrayList;
import java.util.List;


public class ForceTracker 
{
	/**
	 * The list of registered forces.
	 */
	public static List<Force> forces = new ArrayList<Force>();
	
	/**
	 * Register a force.
	 * @param force The Force to be registered.
	 */
	public static void register(Force force)
	{
		forces.add(force);
	}

	/**
	 * Updates the list of forces, to see if any of the force are to be disabled.
	 */
	public static void update() 
	{
		for(int i = forces.size()-1; i >= 0; i--)
			if (forces.get(i).done())
				forces.remove(i);
	}
}
