/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr;

import bwapi.Position;

/**
 * Classes which extend this interface represent a force of units.
 * @author Simon
 *
 */
public interface Force {
	/**
	 * The position which is considered to be the center of the force.
	 * @return The position which is considered to be the center of the force.
	 */
	Position getCenter();
	
	/**
	 * The number of units contained in this force.
	 * @return The number of units contained in this force.
	 */
	public int size();
	
	/**
	 * Is this force still operational?
	 * @return Is this force still operational?
	 */
	public boolean done();
	
	/**
	 * Is the force currently disabled?
	 * @return Is the force currently disabled?
	 */
	public boolean disabled();
}
