/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import bwta.Chokepoint;
import bwta.Region;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.PositionUtil;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.tasks.RunbyTask;
import com.tyr.unitgroups.IAttackGroup;
import java.util.ArrayList;
import java.util.HashSet;

public class PrioritizedAttackGroup
extends IAttackGroup {
    private double maxTargetRange = 300.0;
    public static int ignoreAfterNonAggressive = 300;
    public static int threatRange = 450;
    public static boolean allowRetreat = false;
    public static boolean isAttacking = true;
    private static Region enemyNatural = null;

    public PrioritizedAttackGroup(Position target) {
        super(target);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        for (Agent agent : this.units) {
            agent.drawCircle(Color.Green, 6);
            if (agent.unit.getType() != UnitType.Protoss_Reaver) continue;
            agent.drawCircle(Color.Purple);
            if (agent.unit.isTraining()) continue;
            agent.unit.train(UnitType.Protoss_Scarab);
        }
        boolean retreat = false;
        HashSet<Agent> closeAgents = new HashSet<Agent>();
        HashSet<EnemyPosition> enemyStructures = new HashSet<EnemyPosition>();
        boolean overwhelming = this.units.size() >= 30;
        int minArmy = EnemyManager.getManager().enemyDefensiveStructures.size() > 0 ? 36 : 0;
        minArmy += EnemyManager.getManager().enemyDefensiveStructures.size() * 8;
        minArmy = 0;
        int defensesThreatRange = threatRange;
        if (allowRetreat) {
            int playerStrength = 0;
            int enemyStrength = 0;
            block1: for (Agent agent : this.units) {
                if (agent.unit.getType().groundWeapon() == WeaponType.None) continue;
                for (EnemyPosition enemyStructure : EnemyManager.getManager().enemyDefensiveStructures) {
                    if (agent.distanceSquared(enemyStructure.pos) <= defensesThreatRange * defensesThreatRange && !enemyStructures.contains(enemyStructure)) {
                        enemyStructures.add(enemyStructure);
                        enemyStrength = overwhelming ? (enemyStrength += 8) : (RunbyTask.isCreated() ? (enemyStrength += 80) : (enemyStructure.type == UnitType.Zerg_Sunken_Colony ? (enemyStrength += 30) : (enemyStrength += 20)));
                        defensesThreatRange = threatRange + 320;
                    }
                    if (agent.distanceSquared(enemyStructure.pos) > (threatRange + 80) * (threatRange + 80) || closeAgents.contains(agent)) continue;
                    playerStrength += agent.unit.getType().supplyRequired();
                    closeAgents.add(agent);
                    agent.drawCircle(Color.Purple);
                }
                if (closeAgents.contains(agent)) continue;
                for (Unit unit : EnemyManager.getEnemyUnits()) {
                    if (unit.getType().isFlyer() || unit.getType().isWorker() || agent.distanceSquared(unit) > threatRange * threatRange) continue;
                    if (closeAgents.contains(agent)) continue block1;
                    playerStrength += agent.unit.getType().supplyRequired();
                    closeAgents.add(agent);
                    continue block1;
                }
            }
            for (EnemyPosition pos : enemyStructures) {
                Tyr.drawCircle(pos.pos, Color.Orange, threatRange);
            }
            for (UnitType type : EnemyManager.getManager().getEnemyTypes()) {
                if (type.isFlyer() || type.isBuilding() || type.groundWeapon() == null || type.groundWeapon() == WeaponType.None || type.isWorker()) continue;
                enemyStrength += type.supplyRequired() * EnemyManager.getManager().getAllCount(type);
            }
            DebugMessages.addMessage("Player Strength: " + playerStrength + " enemyStrength: " + enemyStrength + " minArmy: " + minArmy);
            if (RunbyTask.isCreated() && enemyStructures.size() > 0 && this.units.size() >= (EnemyManager.getManager().enemyDefensiveStructures.size() > 1 ? 10 : 5)) {
                RunbyTask.getTask().addRunby(this.units);
                this.units = new ArrayList();
                return;
            }
            int modifiedPlayerStrength = playerStrength;
            if (game.enemy().getRace() != Race.Zerg) {
                modifiedPlayerStrength += playerStrength / 20 * 2;
            }
            if (modifiedPlayerStrength < Math.max(enemyStrength, minArmy) / 2 || game.enemy().getRace() == Race.Zerg && playerStrength <= 4) {
                retreat = true;
                isAttacking = false;
            } else if (modifiedPlayerStrength >= Math.max(enemyStrength, minArmy) + (EnemyManager.getManager().enemyDefensiveStructures.size() > 1 ? 8 : 0)) {
                retreat = false;
                isAttacking = true;
            } else {
                retreat = !isAttacking;
            }
        }
        for (Agent agent : this.units) {
            if (agent.unit.getType() == UnitType.Protoss_Reaver) {
                boolean closeEnemy = false;
                if (agent.unit.isMoving()) {
                    for (Unit enemy : EnemyManager.getEnemyUnits()) {
                        if (enemy.isLifted() || enemy.getType().isFlyer() || agent.distanceSquared(enemy) > 62500) continue;
                        closeEnemy = true;
                        agent.unit.stop();
                        break;
                    }
                }
                if (closeEnemy) continue;
                agent.attack(this.target);
                continue;
            }
            if (agent.unit.getType().groundWeapon() == WeaponType.None && agent.unit.getType().airWeapon() != WeaponType.None) {
                agent.attack(this.target);
                continue;
            }
            if (agent.unit.getType() != UnitType.Protoss_Dark_Templar && retreat && closeAgents.contains(agent) && agent.distanceSquared(Tyr.tileToPosition(self.getStartLocation())) >= 230400) {
                agent.unit.move(Tyr.tileToPosition(self.getStartLocation()));
                agent.drawCircle(Color.Blue);
                continue;
            }
            Unit killTarget = null;
            double distance = Double.MAX_VALUE;
            Unit closeAttackTarget = null;
            int closePriority = 0;
            int priority = 0;
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                double newDistance;
                if (!agent.unit.canAttack(enemy) || (enemy.getType().isFlyer() || enemy.isLifted()) && (agent.unit.getType().airWeapon() == WeaponType.None || agent.unit.getType().airWeapon() == null)) continue;
                int timeSinceAttack = game.getFrameCount() - EnemyManager.getManager().getLastAttackFrame(enemy);
                boolean wall = false;
                if (enemy.getType() == UnitType.Terran_Barracks && !enemy.isLifted()) {
                    if (enemyNatural == null) {
                        enemyNatural = SpaceManager.getEnemyNatural().getRegion();
                    }
                    if (enemyNatural != null) {
                        for (Chokepoint choke : enemyNatural.getChokepoints()) {
                            if (PositionUtil.distanceSq(enemy, choke.getCenter()) > 40000) continue;
                            wall = true;
                        }
                    }
                }
                int newPriority = 0;
                newPriority = enemy.getType() == UnitType.Protoss_Reaver || wall ? 5 : (enemy.getType().isBuilding() ? (enemy.getType().groundWeapon() != null && enemy.getType().groundWeapon() != WeaponType.None ? 4 : 1) : (enemy.getType().isWorker() ? 2 : (timeSinceAttack <= ignoreAfterNonAggressive && enemy.getType().groundWeapon() != null && enemy.getType().groundWeapon() != WeaponType.None ? 3 : 0)));
                if (agent.unit.getType() == UnitType.Protoss_Dark_Templar && enemy.getType() == UnitType.Terran_Missile_Turret) {
                    newPriority = 5;
                }
                if (newPriority > closePriority && agent.unit.isInWeaponRange(enemy) && newPriority > 1) {
                    closePriority = newPriority;
                    closeAttackTarget = enemy;
                }
                if (newPriority < priority || newPriority == 0 || (newDistance = (double)agent.distanceSquared(enemy)) >= this.maxTargetRange * this.maxTargetRange || newPriority == priority && newDistance >= distance) continue;
                killTarget = enemy;
                distance = newDistance;
                priority = newPriority;
            }
            if (killTarget != null && agent.unit.isInWeaponRange(killTarget)) {
                agent.attack(killTarget);
                continue;
            }
            if (closeAttackTarget != null && agent.unit.canAttack()) {
                agent.attack(closeAttackTarget);
                continue;
            }
            if (killTarget != null && !agent.unit.isAttackFrame()) {
                agent.order(new None(agent));
                agent.move(killTarget.getPosition());
                continue;
            }
            if (agent.unit.isAttackFrame()) continue;
            agent.order(new None(agent));
            agent.move(this.target);
        }
    }
}

