/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Order;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import com.tyr.DebugMessages;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.WorkerAgent;
import com.tyr.unitgroups.OutOfJob;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;

public class PatchWorkers
extends UnitGroup {
    public Unit resourceDepot;
    public Unit mineral;

    public PatchWorkers(OutOfJob rejects, Unit resourceDepot, Unit mineral) {
        super(rejects);
        this.resourceDepot = resourceDepot;
        this.mineral = mineral;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.mineral == null) {
            DebugMessages.addMessage("Mineral is null for PatchWorker!");
            return;
        }
        if (!this.mineral.exists()) {
            DebugMessages.addMessage("Mineral does not exist for PatchWorker!");
            this.mineral = null;
            for (Agent agent : this.units) {
                this.rejects.add(agent);
            }
            this.units = new ArrayList();
            return;
        }
        Tyr.drawCircle(this.mineral.getPosition(), Color.Teal, 16);
        for (Agent worker : this.units) {
            worker.drawCircle(Color.Cyan);
            if (worker.unit.isIdle() || worker.unit.isGatheringGas()) {
                worker.unit.gather(this.mineral);
                return;
            }
            Unit target = worker.unit.getTarget();
            if (!worker.unit.isGatheringMinerals() || target == null || !target.getType().isMineralField() || target.getID() == this.mineral.getID()) continue;
            worker.drawCircle(Color.White, 4);
            worker.unit.gather(this.mineral);
        }
    }

    @Override
    public Agent pop() {
        int i = this.units.size() - 1;
        while (i >= 0) {
            if (!((WorkerAgent)this.units.get((int)i)).isBlocked && !((Agent)this.units.get((int)i)).unit.isConstructing() && ((Agent)this.units.get(i)).distanceSquared(this.resourceDepot.getPosition()) <= 0x144000 && ((Agent)this.units.get((int)i)).unit.getOrder() != Order.ConstructingBuilding) {
                Agent result = (Agent)this.units.get(i);
                this.remove(i);
                return result;
            }
            --i;
        }
        return null;
    }

    public Agent pop(Position pos) {
        Agent result = null;
        double distance = Double.MAX_VALUE;
        for (Agent worker : this.units) {
            int newDist;
            if (((WorkerAgent)worker).isBlocked || worker.unit.isConstructing() || !((double)(newDist = worker.distanceSquared(pos)) < distance)) continue;
            distance = newDist;
            result = worker;
        }
        this.units.remove(result);
        return result;
    }

    @Override
    public void add(Agent agent) {
        if (agent == null) {
            return;
        }
        if (agent.unit == null) {
            return;
        }
        super.add(agent);
        if (agent.unit.isConstructing()) {
            return;
        }
        if (this.mineral != null) {
            agent.unit.gather(this.mineral);
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.mineral == null || !this.mineral.exists() || this.mineral.getResources() <= 0) {
            this.mineral = null;
        }
        if (this.mineral == null) {
            for (Agent unit : this.units) {
                this.rejects.add(unit);
            }
            this.units = new ArrayList();
        }
    }
}

