/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Game;
import bwapi.Player;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.unitgroups.MineralWorkers;
import com.tyr.unitgroups.OutOfJob;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;

public class LocalDefendingWorkers
extends UnitGroup {
    private boolean proxyCannon = false;
    private MineralWorkers base;

    public LocalDefendingWorkers(OutOfJob rejects, MineralWorkers base) {
        super(rejects);
        this.base = base;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        Unit invader = this.base.invader;
        int invaderCount = this.base.invaderCount;
        boolean proxy = false;
        for (EnemyPosition building : EnemyManager.getManager().enemyBuildingMemory) {
            if (building.distanceSq(Tyr.tileToPosition(self.getStartLocation())) > Settings.getLargeInvasionDist() * Settings.getLargeInvasionDist()) continue;
            proxy = true;
            if (building.type != UnitType.Protoss_Photon_Cannon || !building.completed) continue;
            this.proxyCannon = true;
            break;
        }
        if (invader == null || invader.getDistance(this.base.resourceDepot) > 300 || this.proxyCannon) {
            for (Agent agent : this.units) {
                this.base.add(agent);
            }
            if (this.units.size() != 0) {
                this.units = new ArrayList();
            }
            return;
        }
        if (this.base.resourceDepot.getDistance(Tyr.tileToPosition(self.getStartLocation())) <= 100) {
            return;
        }
        int desiredDefenders = 0;
        int halfWorkers = this.units.size() + this.base.size();
        desiredDefenders = invaderCount == 1 && !invader.getType().isFlyer() && !proxy ? (invader.getType().isWorker() ? Math.min(1, halfWorkers) : Math.min(3, halfWorkers)) : (invaderCount == 2 && !proxy ? Math.min(5, halfWorkers) : halfWorkers);
        while (this.units.size() < desiredDefenders) {
            this.units.add(this.base.pop(invader.getPosition()));
        }
        while (this.units.size() > desiredDefenders) {
            this.base.add((Agent)this.units.get(this.units.size() - 1));
            this.units.remove(this.units.size() - 1);
        }
        DebugMessages.addMessage("Desired workers: " + desiredDefenders + "Defending: " + this.units.size());
        if (game.getFrameCount() % 100 == 0 && invader != null) {
            for (Agent worker : this.units) {
                if (worker == null) continue;
                if (invaderCount > 1) {
                    worker.unit.attack(invader.getPosition());
                    continue;
                }
                worker.unit.attack(invader);
            }
        }
    }
}

