/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.BunkerAgent;
import com.tyr.agents.None;
import com.tyr.agents.RepairBunker;
import com.tyr.unitgroups.OutOfJob;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;

public class BunkerCrew
extends UnitGroup {
    public Agent bunker;
    public ArrayList<Agent> defenders = new ArrayList();
    private ArrayList<Agent> repairCrew = new ArrayList();

    public BunkerCrew(OutOfJob rejects) {
        super(rejects);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (((BunkerAgent)this.bunker).disabled) {
            this.bunker.unit.unloadAll();
            this.bunker = null;
        }
        if (this.bunker == null || this.bunker.isDead()) {
            this.bunker = null;
            for (Agent def : this.defenders) {
                this.rejects.add(def);
            }
            this.defenders = new ArrayList();
            for (Agent scv : this.repairCrew) {
                this.rejects.add(scv);
            }
            this.repairCrew = new ArrayList();
            return;
        }
        for (Agent def : this.defenders) {
            def.drawCircle(Color.Purple);
            if (!def.unit.isIdle() && def.unit.isMoving()) continue;
            this.bunker.unit.load(def.unit);
        }
    }

    public void addRepairSCV(Agent scv) {
        this.repairCrew.add(scv);
        scv.order(new RepairBunker(scv, this.bunker));
    }

    public Agent removeRepairSCV() {
        Agent result = this.repairCrew.get(this.repairCrew.size() - 1);
        this.repairCrew.remove(this.repairCrew.size() - 1);
        result.order(new None(result));
        return result;
    }

    public int repairingSCVCount() {
        return this.repairCrew.size();
    }

    public void addDefender(Agent def) {
        if (this.bunker != null) {
            def.order(new None(def));
            this.defenders.add(def);
            def.unit.stop();
            this.bunker.unit.load(def.unit);
        } else {
            this.rejects.add(def);
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        int i = 0;
        while (i < this.repairCrew.size()) {
            Agent worker = this.repairCrew.get(i);
            if (worker.isDead()) {
                this.repairCrew.remove(i);
                this.rejects.add(worker);
                --i;
            }
            ++i;
        }
    }
}

