/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Order;
import bwapi.Player;
import bwapi.Position;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.Chokepoint;
import bwta.Region;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.PositionUtil;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.agents.MedicAttack;
import com.tyr.agents.None;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.unitgroups.IAttackGroup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class AttackGroup
extends IAttackGroup {
    private Unit killTarget;
    public static boolean fearLurkers;
    public static boolean offensiveMines;
    public static boolean hunting;
    public static boolean fearBarracks;
    public static boolean killWall;
    private Unit prey;
    private Agent hunter;
    private List<Agent> highTemplar = new ArrayList<Agent>();
    private static Region enemyNatural;
    private boolean attackWall = false;

    static {
        offensiveMines = false;
        hunting = false;
        fearBarracks = false;
        killWall = false;
        enemyNatural = null;
    }

    public AttackGroup(Position target) {
        super(target);
    }

    public void setKillTarget(Unit killTarget) {
        this.killTarget = killTarget;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.killTarget != null) {
            Tyr.drawCircle(this.killTarget.getPosition(), Color.Purple, 16);
        }
        Position medicTarget = this.target;
        for (Agent agent : this.units) {
            if (agent.unit.getGroundWeaponCooldown() <= 0) continue;
            medicTarget = agent.unit.getPosition();
            break;
        }
        ArrayList<Unit> enemyLurkers = new ArrayList<Unit>();
        if (fearLurkers) {
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (enemy.getType() != UnitType.Zerg_Lurker) continue;
                enemyLurkers.add(enemy);
            }
        }
        if (hunting) {
            if (this.prey == null || Agent.isDead(this.prey) || this.hunter == null || this.hunter.isDead()) {
                this.prey = null;
                this.hunter = null;
            }
            if (this.prey == null) {
                ArrayList<Unit> enemyTargets = new ArrayList<Unit>();
                for (Unit enemy : EnemyManager.getEnemyUnits()) {
                    if (enemy.getType() != UnitType.Protoss_Reaver && enemy.getType() != UnitType.Terran_Siege_Tank_Siege_Mode && enemy.getType() != UnitType.Terran_Siege_Tank_Tank_Mode) continue;
                    enemyTargets.add(enemy);
                }
                block3: for (Agent agent : this.units) {
                    if (agent.unit.getType() != UnitType.Protoss_Zealot) continue;
                    for (Unit unit : enemyTargets) {
                        if (agent.distanceSquared(unit) > 90000) continue;
                        this.prey = unit;
                        this.hunter = agent;
                        break block3;
                    }
                }
            }
        }
        if (!this.highTemplar.isEmpty()) {
            this.manageHighTemplar();
        }
        if (enemyNatural == null && bot.suspectedEnemy.size() == 1) {
            enemyNatural = SpaceManager.getEnemyNatural().getRegion();
        }
        Unit wall = null;
        if (enemyNatural != null) {
            for (Chokepoint choke : enemyNatural.getChokepoints()) {
                Tyr.drawCircle(choke.getCenter(), Color.Blue, 200);
            }
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (enemy.getType() != UnitType.Terran_Barracks || enemy.isLifted()) continue;
                Tyr.drawCircle(enemy.getPosition(), Color.Purple, 16);
                for (Chokepoint choke : enemyNatural.getChokepoints()) {
                    if (PositionUtil.distanceSq(enemy, choke.getCenter()) > 40000) continue;
                    wall = enemy;
                }
            }
        }
        boolean dragoonAtWall = false;
        int zealotsAtWall = 0;
        DebugMessages.addMessage("Wall: " + (wall != null));
        Unit wallDepot = null;
        if (wall != null) {
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (enemy.getType() != UnitType.Terran_Supply_Depot) continue;
                Tyr.drawCircle(enemy.getPosition(), Color.Orange, 16);
                if (PositionUtil.distanceSq(wall, enemy) > 100) continue;
                wallDepot = enemy;
            }
        }
        if (wall != null) {
            Tyr.drawCircle(wall.getPosition(), Color.Red, 300);
            for (Agent agent : this.units) {
                if (agent.unit.getType() == UnitType.Protoss_Dragoon && agent.distanceSquared(wall) <= 90000) {
                    dragoonAtWall = true;
                }
                if (agent.unit.getType() != UnitType.Protoss_Zealot || agent.distanceSquared(wall) > 160000) continue;
                ++zealotsAtWall;
            }
        }
        this.attackWall = zealotsAtWall >= 1;
        DebugMessages.addMessage("Zealots at wall: " + zealotsAtWall);
        block10: for (Agent agent : this.units) {
            if (fearBarracks && !dragoonAtWall && !this.attackWall && agent.unit.getType() == UnitType.Protoss_Zealot) {
                for (Unit enemy : EnemyManager.getEnemyUnits()) {
                    if (enemy.getType() != UnitType.Terran_Barracks || agent.distanceSquared(enemy) > 90000) continue;
                    agent.move(Tyr.getStartLocation());
                    continue block10;
                }
            }
            if (killWall && wallDepot != null && (agent.unit.getType() == UnitType.Protoss_Dragoon || agent.unit.getType() == UnitType.Protoss_Zealot && this.attackWall) && agent.distanceSquared(wallDepot) <= 90000) {
                agent.attack(wallDepot);
                agent.drawCircle(Color.Yellow, 6);
                continue;
            }
            if (agent == this.hunter) {
                agent.attack(this.prey);
                game.drawLineMap(agent.unit.getPosition(), this.prey.getPosition(), Color.Red);
                continue;
            }
            if (agent.unit.getType() == UnitType.Protoss_Reaver) {
                if (!agent.unit.isTraining() && agent.unit.getScarabCount() < 5) {
                    agent.unit.train(UnitType.Protoss_Scarab);
                }
            } else if (agent.unit.getType() == UnitType.Protoss_Carrier) {
                if (!agent.unit.isTraining() && agent.unit.getInterceptorCount() < 8) {
                    agent.unit.train(UnitType.Protoss_Interceptor);
                }
                if (agent.unit.isTraining() && agent.unit.getInterceptorCount() < 4) {
                    agent.unit.move(Tyr.getStartLocation());
                }
                if (agent.unit.isTraining() && agent.unit.getInterceptorCount() < 8) {
                    agent.attack(this.target);
                }
                if (agent.unit.isUnderAttack()) {
                    agent.unit.move(Tyr.getStartLocation());
                    continue;
                }
            }
            if (agent.unit.getType() == UnitType.Terran_Marine || agent.unit.getType() == UnitType.Terran_Vulture || agent.unit.getType() == UnitType.Terran_Goliath) {
                for (Unit lurker : enemyLurkers) {
                    if (agent.distanceSquared(lurker) >= 90000) continue;
                    agent.unit.move(Tyr.tileToPosition(self.getStartLocation()));
                    agent.drawCircle(Color.Blue);
                }
                if (fearLurkers) {
                    for (EnemyPosition defensive : EnemyManager.getManager().enemyDefensiveStructures) {
                        if (agent.distanceSquared(defensive.pos) >= 90000) continue;
                        agent.unit.move(Tyr.tileToPosition(self.getStartLocation()));
                        agent.drawCircle(Color.Blue);
                    }
                }
            }
            if (agent.unit.getType() == UnitType.Terran_Vulture && self.hasResearched(TechType.Spider_Mines) && agent.unit.getSpiderMineCount() > 0 && game.getFrameCount() % 100 == 0 && offensiveMines) {
                boolean mined = false;
                for (Unit enemy : EnemyManager.getEnemyUnits()) {
                    if (enemy.getType().isFlyer() || enemy.getType().isWorker() || enemy.getType().isBuilding() || enemy.getType() == UnitType.Protoss_Zealot || agent.distanceSquared(enemy) > 90000) continue;
                    agent.unit.useTech(TechType.Spider_Mines, agent.unit.getPosition());
                    agent.drawCircle(Color.Red, 300);
                    agent.drawCircle(Color.Red, 6);
                    mined = true;
                    break;
                }
                if (mined) continue;
                agent.drawCircle(Color.Yellow, 300);
            } else if (agent.unit.getType() == UnitType.Terran_Vulture) {
                if (!self.hasResearched(TechType.Spider_Mines)) {
                    agent.drawCircle(Color.Green, 6);
                } else if (agent.unit.getSpiderMineCount() <= 0) {
                    agent.drawCircle(Color.Blue, 6);
                }
            }
            if (agent.unit.getType() == UnitType.Terran_Medic) {
                agent.order(new MedicAttack(agent, medicTarget));
            }
            if (agent.unit.getType() == UnitType.Protoss_Dark_Templar) {
                boolean retreat = false;
                for (Unit enemy : EnemyManager.getEnemyUnits()) {
                    if (!enemy.getType().isDetector() || agent.distanceSquared(enemy) > 160000) continue;
                    retreat = true;
                }
                if (!retreat) continue;
                agent.move(Tyr.getStartLocation());
                continue;
            }
            if (this.killTarget != null) {
                agent.order(new None(agent));
                if (agent.distanceSquared(this.killTarget) <= agent.unit.getType().groundWeapon().maxRange() * agent.unit.getType().groundWeapon().maxRange()) {
                    agent.attack(this.killTarget);
                    continue;
                }
                agent.unit.move(this.killTarget.getPosition());
                continue;
            }
            agent.order(new Attack(agent, this.target));
        }
    }

    private void manageHighTemplar() {
        HashSet<Unit> stormTargets = new HashSet<Unit>();
        for (Unit enemy : EnemyManager.getEnemyUnits()) {
            if (enemy.getType().isBuilding() || enemy.getType() == UnitType.Zerg_Overlord) continue;
            int count = 1;
            for (Unit enemy2 : EnemyManager.getEnemyUnits()) {
                if (enemy.getType().isBuilding() || enemy.getType() == UnitType.Zerg_Overlord || Math.abs(enemy.getX() - enemy2.getX()) > 48 || Math.abs(enemy.getY() - enemy2.getY()) > 48) continue;
                ++count;
            }
            if (count < 6) continue;
            stormTargets.add(enemy);
        }
        block2: for (Agent agent : this.highTemplar) {
            if (agent.unit.getOrder() == Order.CastPsionicStorm) continue;
            boolean canStorm = Tyr.self.hasResearched(TechType.Psionic_Storm) && agent.unit.getEnergy() >= 75;
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                int dist = agent.distanceSquared(enemy);
                if (!enemy.getType().isBuilding() && enemy.getType() != UnitType.Zerg_Overlord && dist <= 90000 && canStorm && stormTargets.contains(enemy)) {
                    agent.unit.useTech(TechType.Psionic_Storm, enemy.getPosition());
                }
                if (dist <= 22500) {
                    int dx = agent.unit.getX() - enemy.getX();
                    int dy = agent.unit.getX() - enemy.getX();
                    double length = Math.sqrt(dx * dx + dy * dy);
                    Position fleePos = new Position((int)((double)agent.unit.getX() + (double)(dx * 64) / length), (int)((double)agent.unit.getY() + (double)(dy * 64) / length));
                    agent.move(fleePos);
                    continue;
                }
                if (dist > 62500) continue;
                agent.move(Tyr.getStartLocation());
                continue block2;
            }
            agent.unit.move(this.target);
        }
    }

    @Override
    public void add(Agent agent) {
        if (agent.unit.getType() == UnitType.Protoss_High_Templar) {
            this.highTemplar.add(agent);
            agent.order(new None(agent));
            agent.unit.stop();
        }
        super.add(agent);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        Agent.clean(this.highTemplar);
    }
}

