/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import com.tyr.DebugMessages;
import com.tyr.Tyr;
import com.tyr.tasks.AttackTask;
import com.tyr.tasks.ClearMineralTask;
import com.tyr.tasks.DefendMainTask;
import com.tyr.tasks.ObserverTask;
import com.tyr.tasks.ScanTask;
import com.tyr.tasks.Task;
import java.util.ArrayList;

public class TaskManager {
    public ArrayList<Task> potentialTasks = new ArrayList();
    private ScanTask scanTask;
    private ObserverTask observerTask;

    public TaskManager() {
        this.potentialTasks.add(new DefendMainTask(false));
        this.potentialTasks.add(new DefendMainTask(true));
        this.potentialTasks.add(new AttackTask());
        this.potentialTasks.add(new ClearMineralTask());
        this.scanTask = new ScanTask();
        if (Tyr.self.getRace() == Race.Protoss) {
            this.observerTask = new ObserverTask();
        }
    }

    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.observerTask != null && this.observerTask.isRequired(game, self, bot)) {
            if (!this.observerTask.isBeingSolved()) {
                this.observerTask.findSolution(game, self, bot);
            }
            if (this.observerTask.isBeingSolved()) {
                this.observerTask.solve(game, self, bot);
            }
        }
        if (this.scanTask != null && this.scanTask.isRequired(game, self, bot)) {
            if (!this.scanTask.isBeingSolved()) {
                this.scanTask.findSolution(game, self, bot);
            }
            if (this.scanTask.isBeingSolved()) {
                this.scanTask.solve(game, self, bot);
                DebugMessages.addMessage("Scanning.");
                return;
            }
        }
        for (Task task : this.potentialTasks) {
            boolean isRequired = task.isRequired(game, self, bot);
            if (isRequired && !task.isBeingSolved()) {
                task.findSolution(game, self, bot);
            }
            if (!isRequired || !task.isBeingSolved()) continue;
            task.solve(game, self, bot);
        }
    }

    public void disableScanner() {
        this.scanTask = null;
    }
}

