/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import com.tyr.DebugMessages;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.tasks.TargetableSolution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.AttackGroup;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;

public class SendTroopsSolution
extends TargetableSolution {
    private AttackGroup attackGroup;
    private Position target;
    private boolean addedToScanner = false;

    public SendTroopsSolution(Task task, Position target) {
        super(task);
        this.target = target;
        this.attackGroup = new AttackGroup(target);
    }

    @Override
    public void setTarget(Position target) {
        this.target = target;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        this.attackGroup.setTarget(this.target);
        DebugMessages.addMessage("Defending units size: " + this.attackGroup.units.size());
        this.attackGroup.cleanup();
        this.attackGroup.onFrame(game, self, bot);
    }

    @Override
    public void add(Agent unit) {
        this.attackGroup.add(unit);
    }

    @Override
    public int getCount() {
        return this.attackGroup.units.size();
    }

    @Override
    public void done(UnitGroup unitGroup) {
        for (Agent unit : this.attackGroup.units) {
            unitGroup.add(unit);
            unit.order(new None(unit));
        }
        this.attackGroup.units = new ArrayList();
    }

    public void addToScanner() {
        if (this.addedToScanner) {
            return;
        }
        this.addedToScanner = true;
        for (Agent agent : this.attackGroup.units) {
            Tyr.bot.scanner.add(agent);
        }
    }

    public int distanceSq(Position target) {
        int distance = Integer.MAX_VALUE;
        for (Agent agent : this.attackGroup.units) {
            distance = Math.min(distance, agent.distanceSquared(target));
        }
        return distance;
    }
}

