/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.MarineHarassGroup;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;

public class MarineHarassSolution
extends Solution {
    private MarineHarassGroup attackGroup;
    private Position attackTarget;

    public MarineHarassSolution(Task task, Position attackTarget) {
        super(task);
        this.attackTarget = attackTarget;
        this.attackGroup = new MarineHarassGroup(attackTarget);
    }

    public void setTarget(Position attackTarget) {
        this.attackTarget = attackTarget;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        Tyr.drawCircle(this.attackTarget, Color.Orange, 64);
        this.attackGroup.cleanup();
        this.attackGroup.setTarget(this.attackTarget);
        this.attackGroup.onFrame(game, self, bot);
        boolean attackerRemaining = false;
        for (Agent agent : this.attackGroup.units) {
            if (agent.unit.getType() == UnitType.Terran_Medic) continue;
            attackerRemaining = true;
            break;
        }
        if (!attackerRemaining) {
            this.attackGroup.clear();
        }
    }

    public void add(Agent agent) {
        this.attackGroup.add(agent);
    }

    public void done(UnitGroup unitGroup) {
        for (Agent unit : this.attackGroup.units) {
            unitGroup.add(unit);
            unit.order(new None(unit));
        }
        this.attackGroup.units = new ArrayList();
    }

    public void clear() {
        this.attackGroup.clear();
    }

    public int size() {
        return this.attackGroup.units.size();
    }
}

