/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.TechType;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.agents.VultureAgent;
import com.tyr.tasks.MineGridSolution;
import com.tyr.tasks.Task;

public class LayMinesTask
extends Task {
    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        if (this.solution != null) {
            return true;
        }
        return this.solution != null || self.hasResearched(TechType.Spider_Mines);
    }

    @Override
    public void solve(Game game, Player self, Tyr bot) {
        MineGridSolution mineSolution = (MineGridSolution)this.solution;
        if (EnemyManager.getManager().getInvaderCount() > 0) {
            Agent previous = mineSolution.pop();
            if (previous != null) {
                previous.order(new None(previous));
                if (previous != null) {
                    bot.homeGroup.add(previous);
                }
            }
            super.solve(game, self, bot);
            return;
        }
        if (mineSolution.vultureNeeded()) {
            Agent previous = mineSolution.pop();
            if (previous != null) {
                bot.homeGroup.add(previous);
            }
            int i = 0;
            while (i < bot.homeGroup.units.size()) {
                Agent agent = (Agent)bot.homeGroup.units.get(i);
                if (agent instanceof VultureAgent && agent.unit.getSpiderMineCount() > 0 && !((VultureAgent)agent).isBlocked) {
                    bot.homeGroup.remove(i);
                    mineSolution.setVulture((VultureAgent)agent);
                    break;
                }
                ++i;
            }
        }
        super.solve(game, self, bot);
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        this.solution = new MineGridSolution(this);
    }
}

