/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.PositionUtil;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.DefendWorkerRushSolution;
import com.tyr.tasks.SendTroopsSolution;
import com.tyr.tasks.TargetableSolution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.HomeGroup;

public class DefendMainTask
extends Task {
    private Unit invader;
    private boolean flyers;
    public static boolean workerRush = false;
    public static boolean keepZealotsBack = false;
    public static boolean maxFlyerDefense = false;

    public DefendMainTask(boolean flyers) {
        this.flyers = flyers;
    }

    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        if (!Settings.getDefendMain()) {
            if (!this.flyers) {
                DebugMessages.addMessage("Not defending main!");
            }
            return false;
        }
        if (!this.flyers && workerRush) {
            return true;
        }
        this.invader = this.flyers ? EnemyManager.getManager().getFlyingInvader() : EnemyManager.getManager().getInvader();
        if (this.invader == null && this.solution != null) {
            this.getSolution().done(bot.homeGroup);
            this.solution = null;
        }
        return this.invader != null;
    }

    @Override
    public void solve(Game game, Player self, Tyr bot) {
        int invaders;
        if (workerRush && !(this.solution instanceof DefendWorkerRushSolution)) {
            ((SendTroopsSolution)this.solution).done(bot.homeGroup);
            this.solution = new DefendWorkerRushSolution(this, null);
        }
        int required = this.flyers && !maxFlyerDefense ? invaders + ((invaders = EnemyManager.getManager().getFlyingInvaderCount()) == 1 ? 2 : 3) : Integer.MAX_VALUE;
        Unit invader = this.flyers ? EnemyManager.getManager().getFlyingInvader() : EnemyManager.getManager().getInvader();
        int invadingDist = invader != null ? PositionUtil.distanceSq(Tyr.tileToPosition(self.getStartLocation()), invader) : 1000000;
        int i = bot.homeGroup.units.size() - 1;
        while (i >= 0) {
            if (EnemyManager.getManager().getInvaderCount() == 1 && EnemyManager.getManager().getInvader() != null && EnemyManager.getManager().getInvader().getType().isWorker() && this.getSolution().getCount() >= 1 || this.getSolution().getCount() >= required) break;
            Agent agent = (Agent)bot.homeGroup.units.get(i);
            if (!(agent.unit.getType() == UnitType.Protoss_Zealot && keepZealotsBack && invadingDist >= 160000 || HomeGroup.keepTanksSieged && agent.isTank() || (agent.unit.getType() == UnitType.Terran_Battlecruiser || !this.flyers || agent.unit.getType().airWeapon() == WeaponType.None) && (this.flyers || agent.unit.getType().groundWeapon() == WeaponType.None && agent.unit.getType() != UnitType.Protoss_Reaver))) {
                this.getSolution().add(agent);
                bot.homeGroup.units.remove(i);
            }
            --i;
        }
        if (this.solution != null && invader != null) {
            this.getSolution().setTarget(invader.getPosition());
        }
        super.solve(game, self, bot);
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        if (this.invader != null) {
            this.solution = new SendTroopsSolution(this, this.invader.getPosition());
        }
    }

    public TargetableSolution getSolution() {
        return (TargetableSolution)this.solution;
    }
}

