/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.AttackGroup;
import com.tyr.unitgroups.AttackNaturalGroup;
import com.tyr.unitgroups.DistributeAttackGroup;
import com.tyr.unitgroups.IAttackGroup;
import com.tyr.unitgroups.PrioritizedAttackGroup;
import com.tyr.unitgroups.UnitGroup;
import com.tyr.unitgroups.WallAttackGroup;
import java.util.ArrayList;

public class ConstantPushSolution
extends Solution {
    private IAttackGroup attackGroup;
    private Position attackTarget;
    public static final int ATTACK = 0;
    public static final int PRIORITIZE = 1;
    public static final int ATTACK_NATURAL = 2;
    public static final int DISTRIBUTE = 3;
    public static final int ATTACK_WALL = 4;
    private boolean addedToScanner = false;

    public ConstantPushSolution(Task task, Position attackTarget) {
        this(task, attackTarget, 0);
    }

    public ConstantPushSolution(Task task, Position attackTarget, int mode) {
        super(task);
        this.attackTarget = attackTarget;
        this.attackGroup = mode == 1 ? new PrioritizedAttackGroup(attackTarget) : (mode == 2 ? new AttackNaturalGroup(attackTarget) : (mode == 3 ? new DistributeAttackGroup(attackTarget) : (mode == 4 ? new WallAttackGroup(attackTarget) : new AttackGroup(attackTarget))));
    }

    public void setTarget(Position attackTarget) {
        this.attackTarget = attackTarget;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        Tyr.drawCircle(this.attackTarget, Color.Orange, 64);
        this.attackGroup.cleanup();
        this.attackGroup.setTarget(this.attackTarget);
        this.attackGroup.onFrame(game, self, bot);
    }

    public void add(Agent agent) {
        this.attackGroup.add(agent);
    }

    public void done(UnitGroup unitGroup) {
        for (Agent unit : this.attackGroup.units) {
            unitGroup.add(unit);
            unit.order(new None(unit));
        }
        this.attackGroup.units = new ArrayList();
    }

    public void addToScanner() {
        if (this.addedToScanner) {
            return;
        }
        this.addedToScanner = true;
        for (Agent agent : this.attackGroup.units) {
            Tyr.bot.scanner.add(agent);
        }
    }

    public void clear() {
        this.attackGroup.clear();
    }

    public int size() {
        return this.attackGroup.units.size();
    }

    public boolean done() {
        return this.size() == 0;
    }
}

