/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.Unit;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.ClearMineralSolution;
import com.tyr.tasks.Task;

public class ClearMineralTask
extends Task {
    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        if (this.solution != null) {
            return true;
        }
        if (game.getFrameCount() < 10) {
            return false;
        }
        return this.solution != null || this.getBlockingMineral() != null;
    }

    @Override
    public void solve(Game game, Player self, Tyr bot) {
        ClearMineralSolution clearSolution = (ClearMineralSolution)this.solution;
        if (clearSolution.finished) {
            Agent worker = clearSolution.pop();
            if (worker != null) {
                bot.hobos.add(worker);
            }
            this.solution = null;
            return;
        }
        if (clearSolution.workerNeeded()) {
            clearSolution.setWorker(bot.workForce.pop(clearSolution.getPosition()));
        }
        super.solve(game, self, bot);
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        this.solution = new ClearMineralSolution(this, this.getBlockingMineral().getPosition());
    }

    private Unit getBlockingMineral() {
        Unit blockingMineral = null;
        for (Unit mineral : Tyr.game.neutral().getUnits()) {
            if (!mineral.getType().isMineralField() || mineral.getResources() > 0 || mineral.getDistance(Tyr.tileToPosition(Tyr.self.getStartLocation())) >= Settings.getLargeInvasionDist()) continue;
            blockingMineral = mineral;
            break;
        }
        return blockingMineral;
    }
}

