/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;
import bwta.BaseLocation;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.ScannerListener;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.AntiLurkerSolution;
import com.tyr.tasks.AttackRegroupSolution;
import com.tyr.tasks.Solution;
import com.tyr.tasks.SolutionItem;
import com.tyr.tasks.SolutionList;
import com.tyr.tasks.Task;
import java.util.Iterator;

public class AttackTask
extends Task
implements ScannerListener {
    private Position target;
    private static int previousAttackSize = 0;
    private static boolean attackSent = false;
    public static boolean useAntiLurker;
    private static AttackTask attackTask;

    public AttackTask() {
        Settings.addScannerListener(this);
        attackTask = this;
    }

    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        if (this.solution != null) {
            if (((SolutionList)this.solution).size() == 0) {
                this.solution = null;
            } else {
                return true;
            }
        }
        if (this.solution == null && Settings.getBlockAttack()) {
            return false;
        }
        return bot.homeGroup.units.size() >= this.getNextAttackSize() || self.supplyUsed() >= 400 && bot.homeGroup.units.size() > 0;
    }

    private int getNextAttackSize() {
        return Math.min(Math.max(previousAttackSize + 5, Settings.getRequiredSize()), Settings.getMaximumSize());
    }

    private void setPreviousAttackSize(int val) {
        previousAttackSize = val;
    }

    public void addToScanner() {
        if (this.solution != null) {
            for (Solution solution : ((SolutionList)this.solution).solutions) {
                if (useAntiLurker) {
                    ((AntiLurkerSolution)solution).addToScanner();
                    continue;
                }
                ((AttackRegroupSolution)solution).addToScanner();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void solve(Game game, Player self, Tyr bot) {
        boolean newTarget = this.acquireTarget(bot);
        if (newTarget) {
            for (Solution solution : ((SolutionList)this.solution).solutions) {
                if (useAntiLurker) {
                    ((AntiLurkerSolution)solution).setTarget(this.target);
                    continue;
                }
                ((AttackRegroupSolution)solution).setTarget(this.target);
            }
        }
        if (bot.homeGroup.units.size() >= this.getNextAttackSize() || self.supplyUsed() >= 400 && bot.homeGroup.units.size() > 0) {
            void var5_8;
            int n = bot.homeGroup.units.size() - 1;
            while (var5_8 >= 0) {
                SolutionItem sol = useAntiLurker ? new AntiLurkerSolution(this, this.target) : new AttackRegroupSolution(this, this.target);
                while (var5_8 >= 0 && sol.size() < 15) {
                    Agent agent = (Agent)bot.homeGroup.units.get((int)var5_8);
                    if (agent.unit.getType() != UnitType.Terran_Battlecruiser && agent.unit.getType() != UnitType.Terran_Science_Vessel) {
                        sol.add(agent);
                        bot.homeGroup.units.remove((int)var5_8);
                    }
                    --var5_8;
                }
                ((SolutionList)this.solution).add(sol);
            }
            attackSent = true;
            this.setPreviousAttackSize(this.getNextAttackSize());
        }
        super.solve(game, self, bot);
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        this.solution = new SolutionList(this);
    }

    public boolean acquireTarget(Tyr bot) {
        if (this.target != null) {
            for (EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory) {
                if (p.pos.getX() != this.target.getX() || p.pos.getY() != this.target.getY()) continue;
                return false;
            }
        }
        Position newTarget = null;
        Iterator<Object> iterator = EnemyManager.getManager().enemyBuildingMemory.iterator();
        if (iterator.hasNext()) {
            EnemyPosition p = iterator.next();
            newTarget = p.pos;
        }
        if (newTarget == null && (iterator = bot.suspectedEnemy.iterator()).hasNext()) {
            BaseLocation b = (BaseLocation)iterator.next();
            newTarget = b.getPosition();
        }
        if (newTarget == null) {
            return false;
        }
        if (this.target == null) {
            this.target = newTarget;
            return true;
        }
        if (this.target.getX() == newTarget.getX() && this.target.getY() == newTarget.getY()) {
            return false;
        }
        this.target = newTarget;
        return true;
    }

    @Override
    public void onScannerEliminating() {
        if (this.solution != null) {
            for (Solution solution : ((SolutionList)this.solution).solutions) {
                if (useAntiLurker) {
                    ((AntiLurkerSolution)solution).clear();
                    continue;
                }
                ((AttackRegroupSolution)solution).clear();
            }
        }
        this.solution = null;
    }

    public static boolean getAttackSent() {
        return attackSent;
    }

    public static void setAttackSent(boolean val) {
        attackSent = val;
    }

    public static void cancelAttacks() {
        for (SolutionItem sol : ((SolutionList)AttackTask.attackTask.solution).solutions) {
            sol.clear();
        }
    }
}

