/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;
import com.tyr.DebugMessages;
import com.tyr.Settings;
import com.tyr.StopWatch;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.DefensiveMech;
import com.tyr.builds.GenericPartFactory;
import com.tyr.builds.SupplyDepotPart;
import com.tyr.builds.TAntiCannon;
import com.tyr.builds.TAntiZealot;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.requirements.UnitRequirement;
import com.tyr.unitgroups.ScoutGroup;

public class TvPGeneric
extends CompositeBuildOrder {
    private DefensiveMech mech = new DefensiveMech(true, true, true);
    private TAntiCannon antiCannon = new TAntiCannon();
    private TAntiZealot antiZealot = new TAntiZealot();
    private int mode = 0;
    private static final int NONE = 0;
    private static final int MECH = 1;
    private static final int ANTI_CANNON = 2;
    private static final int ANTI_ZEALOT = 3;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(20);
        Settings.setMaximumSize(40);
        Settings.setWorkersPerGas(1);
        this.add(new SupplyDepotPart());
        this.add(new WorkerScoutPart(1600));
        this.add(new GenericPartFactory(UnitType.Terran_Barracks).setCost(100, 0).create());
        this.add(new GenericPartFactory(UnitType.Terran_Engineering_Bay).setMax(2).add(new UnitRequirement(UnitType.Terran_Marine, 20)).add(new UnitRequirement(UnitType.Terran_Academy)).create());
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        DebugMessages.addMessage("TvP build.");
        StopWatch watch = new StopWatch();
        watch.start();
        super.onFrame(game, self, bot);
        long time = watch.time();
        if (time > 55L) {
            DebugMessages.addMessage("TvP super time: " + time);
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                int count = structures.getUnitCount(UnitType.Terran_Bunker);
                if (bot.defensiveStructures.size() > 1 && structures.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) <= 200.0 || count >= 1) continue;
                bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
                break;
            }
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio bunker time: " + time);
        }
        if (this.mode == 0) {
            this.mode = 1;
            this.mech.initialize(game, self, bot);
        }
        if (this.mode == 0 || this.mode == 1) {
            if (bot.scout.opponentStrategy == ScoutGroup.cannons) {
                this.mode = 2;
                this.antiCannon.initialize(game, self, bot);
            } else if (bot.scout.opponentStrategy == ScoutGroup.zealotPush && UnitTracker.count(UnitType.Terran_Vulture) < 5) {
                this.mode = 3;
                this.antiZealot.initialize(game, self, bot);
            }
        }
        if (this.mode == 3 && UnitTracker.count(UnitType.Terran_Vulture) >= 10) {
            this.mode = 1;
        }
        if (this.mode == 1) {
            this.mech.onFrame(game, self, bot);
        }
        if (this.mode == 2) {
            this.antiCannon.onFrame(game, self, bot);
        }
        if (this.mode == 3) {
            this.antiZealot.onFrame(game, self, bot);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (super.overrideStructureOrder(game, self, bot, agent)) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Barracks && UnitTracker.count(UnitType.Terran_Marine) < 4 * UnitTracker.count(UnitType.Terran_Bunker)) {
            return false;
        }
        if (this.mode == 1) {
            return this.mech.overrideStructureOrder(game, self, bot, agent);
        }
        if (this.mode == 2) {
            return this.antiCannon.overrideStructureOrder(game, self, bot, agent);
        }
        if (this.mode == 3) {
            return this.antiZealot.overrideStructureOrder(game, self, bot, agent);
        }
        return false;
    }
}

